import matplotlib.pyplot as plt
import numpy as np
import math

m = 5
n = 20

# DP = np.arange(0.1, 0.5, 0.1)
DP = [0.4, 0.3, 0.2, 0.1]
CL = np.arange(0, 2, 0.1)
# MK = ['X-', 'o-', 's-', 'd-', '*-']
LINE = ['-', ':', '-.', '--']

def cal(eps, x):
    y = math.e**(n * eps)
    return (y - x) / y


i = 0
LABELS = []
for eps in DP:
    SD = []
    for x in CL:
        SD.append(cal(eps, x))
    # plt.plot(CL, SD, MK[i], markersize=10)
    plt.plot(CL, SD, linestyle=LINE[i], linewidth=3.5)
    # plt.plot(CL, SD, linewidth=3.5)
    i += 1
    Legend_e = "$\epsilon$ = " + str(round(eps, 1))
    LABELS.append(Legend_e)

plt.legend(labels=LABELS, loc='best', fontsize=19)
plt.xticks([0, 0.6, 1.2, 1.8], size=21)
plt.yticks(size=21)

plt.ylabel('$\gamma$-SD-Efficiency', size=21)
plt.xlabel('$\eta$-Condorcet Loser Criterion', size=21)

plt.show()