import matplotlib.pyplot as plt
import numpy as np
import math

m = 5
n = 10

CW = np.arange(1, 2, 0.01)
# DP = np.arange(1, 3, 0.5)
DP = [1, 1.5, 2, 2.5]
DP.reverse()
# MK = ['X-', 'o-', 's-', 'd-', '*-']
LINE = ['-', '--', '-.', ':']

def cal(eps, x):
    return math.e**eps / x

i = 0
LABELS = []
for eps in DP:
    CL = []
    for x in CW:
        CL.append(cal(eps, x))
    plt.plot(CW, CL, linestyle=LINE[i], linewidth=3.5)
    # plt.plot(CW, CL, linewidth=3.5)
    i += 1
    Legend_e = "$\epsilon$ = " + str(eps)
    LABELS.append(Legend_e)

# LABELS.reverse()
# plt.xlim(0, 1)
# plt.ylim(0, 12)

plt.legend(labels=LABELS, loc='best', fontsize="13")
plt.xticks(size=17)
plt.yticks(size=17)

plt.xlabel('$\\alpha$-Condorcet Criterion', size=17)
plt.ylabel('$\eta$-Condorcet Loser Criterion', size=17)

plt.show()