import matplotlib.pyplot as plt
import numpy as np
import math

m = 5
n = 10

DP = np.arange(0, 5, 0.05)


def upper(x):
    y = n*x
    y /= (m-1)
    return math.e**y


def lower(x):
    y = n*x
    y /= 2 * (m-1)
    return math.e**y


LowerPareto = []
for x in DP:
    LowerPareto.append(lower(x))

UpperPareto = []
for x in DP:
    UpperPareto.append(upper(x))

# plt.plot(DP, LowerPareto, 'o-', markersize=10)
# plt.plot(DP, UpperPareto, 'd-', markersize=10)
plt.plot(DP, UpperPareto, linestyle="-", linewidth=3.5)
plt.plot(DP, LowerPareto, linestyle="--", linewidth=3.5)

plt.yscale('log')

# plt.xlim(0, 1)
# plt.ylim(0, 12)

plt.legend(labels=['Upper Bound', 'Lower Bound'], loc='best', fontsize="21")
plt.xticks([0, 1, 2, 3, 4, 5], size=21)
plt.yticks(size=21)

plt.xlabel('Privacy Budget $\epsilon$', size=21)
plt.ylabel('$\\beta$-Pareto Efficiency', size=21)

# plt.savefig('a.pdf', bbox_inches='tight')

plt.show()
