import matplotlib.pyplot as plt
import numpy as np
import math

m = 5
n = 10

# DP = np.arange(0, 0.5, 0.025)
DP = np.arange(0, 5, 0.01)

def upper(x):
    y = (m-1) * math.e**(n * x)
    return y / (y + 1)

def lower(x):
    y = (m-1) * math.e**x
    return y / (y + 1)

LowerSD = []
for x in DP:
    LowerSD.append(lower(x))

UpperSD = []
for x in DP:
    UpperSD.append(upper(x))

plt.plot(DP, UpperSD, linestyle="-", linewidth=3.5)
plt.plot(DP, LowerSD, linestyle="--", linewidth=3.5)

# plt.xlim(0, 1)
# plt.ylim(0, 12)

plt.legend(labels=['Upper Bound', 'Lower Bound'], loc='best', fontsize="21")
plt.xticks(size=21)
plt.yticks([0.80, 0.85, 0.90, 0.95, 1.0], size=21)

plt.xlabel('Privacy Budget $\epsilon$', size=21)
plt.ylabel('$\gamma$-SD-Efficiency', size=21)

plt.show()