import matplotlib.pyplot as plt
import numpy as np
import math

m = 5
n = 10

# DP = np.arange(0.1, 0.5, 0.1)
DP = [0.4, 0.3, 0.2, 0.1]
PE = np.arange(0, 2, 0.1)
# MK = ['X-', 'o-', 's-', 'd-', '*-']
LINE = ['-', ':', '-.', '--']

def cal(eps, x):
    if x == 1:
        return (3 * math.e**(n * eps)) / (1 + 3 * math.e**(n * eps))
    y = math.e**(n * eps) - math.e**(n * eps) * (x**(2-m))
    return y / (y + x - 1)


i = 0
LABELS = []
for eps in DP:
    SD = []
    for x in PE:
        SD.append(cal(eps, x))
    # plt.plot(PE, SD, MK[i], markersize=10)
    plt.plot(PE, SD, linestyle=LINE[i], linewidth=3.5)
    i += 1
    Legend_e = "$\epsilon$ = " + str(round(eps, 1))
    LABELS.append(Legend_e)

plt.legend(labels=LABELS, loc='best', fontsize=19)
plt.xticks([0, 0.6, 1.2, 1.8], size=21)
plt.yticks(size=21)

plt.ylabel('$\gamma$-SD-Efficiency', size=21)
plt.xlabel('$\\beta$-Pareto Efficiency', size=21)

plt.show()