# Distributed Graph-Attention MAPPO (DG-MAPPO)

This is the **official implementation** of DG-MAPPO. DG-MAPPO is a novel fully distributed MARL algorithm that can train collaborative policies using multi-hop communication with immediate neighbors. 

In short, DG-MAPPO:

* Performs global state inference using D-GAT communication module.

* Trains local copies of global critic.

* Estimates global advantage estimates locally using GAE with shared/averaged reward and local critic.

* leverages the multi-agent policy gradient theorem to train collaborative policies without any centralized training.

* achieves superior performance compared to baseline CTDE algorithms on the StarCraftII benchmarks.

## Installation

### Dependences
``` Bash
pip install -r requirements.txt
```

### StarCraft II & SMAC
Run the script
``` Bash
bash install_sc2.sh
```
Or you could install them manually to other path you like, just follow here: https://github.com/oxwhirl/smac.

## How to run
When your environment is ready, you could run shells in the "scripts" folder with algo="mappo_dgnn_dsgd". For example:
``` Bash
./train_smac.sh  # run DG-MAPPO on StarCraftII
```
If you would like to change the configs of experiments, you could modify sh files or look for config.py for more details.

