from mmengine.runner import set_random_seed
import os, sys
import os.path as osp
import random, pdb, math, copy
import mmengine
from mmengine.runner import Runner
from mmaction.apis import inference_recognizer, init_recognizer
from mmengine import Config
from mmaction.utils import register_all_modules
import argparse

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='CAiDA')
    parser.add_argument('--gpu_id', type=str, nargs='?', default='3', help="device id to run")
    parser.add_argument('--dset', type=str, default='Sports-DA', choices=[])
    parser.add_argument('--net', type=str, default='swinl', help="resnet50,vit_b_16,clip_ViT-B/32")
    parser.add_argument('--output', type=str, default=)

    args = parser.parse_args()
    register_all_modules(init_default_scope=True)

    if args.dset == 'Sports-DA':
        names = ['sports1m', 'UCF101']
        args.class_num = 23

    
    if args.net == 'i3d':
        cfg = Config.fromfile('')
        cfg.load_from = 'https://download.openmmlab.com/mmaction/v1.0/recognition/i3d/i3d_imagenet-pretrained-r50-nl-dot-product_8xb8-32x2x1-100e_kinetics400-rgb/i3d_imagenet-pretrained-r50-nl-dot-product_8xb8-32x2x1-100e_kinetics400-rgb_20220812-8e1f2148.pth'
    
    oripath = args.output
    for name in names:       

        if name =='sports1m':
            continue
            cfg.data_root = 
            cfg.ann_file_train = 
            cfg.data_root_val = 
            cfg.ann_file_val = 

            cfg.test_dataloader.dataset.ann_file = 
            cfg.test_dataloader.dataset.data_prefix.video = 

            cfg.train_dataloader.dataset.ann_file = 
            cfg.train_dataloader.dataset.data_prefix.video = 

            cfg.val_dataloader.dataset.ann_file = 
            cfg.val_dataloader.dataset.data_prefix.video  = 
            cfg.model.cls_head.num_classes = args.class_num 

            cfg.train_cfg.max_epochs = 30

            cfg.train_dataloader.num_workers = 8
            cfg.test_dataloader.num_workers = 8
            work_dir = osp.join(oripath, args.net, name)
            if not osp.exists(work_dir):
                os.system('mkdir -p ' + work_dir)
            if not osp.exists(work_dir):
                os.mkdir(work_dir)
            cfg.work_dir = work_dir
            runner = Runner.from_cfg(cfg)

            runner.train()

            runner.test()
        
        elif name =='UCF101':
            # continue
            cfg.data_root = 
            cfg.ann_file_train = 
            cfg.data_root_val = '
            cfg.ann_file_val = 

            cfg.test_dataloader.dataset.ann_file = 
            cfg.test_dataloader.dataset.data_prefix.video = 

            cfg.train_dataloader.dataset.ann_file = 
            cfg.train_dataloader.dataset.data_prefix.video = 

            cfg.val_dataloader.dataset.ann_file = 
            cfg.val_dataloader.dataset.data_prefix.video  = '
            cfg.model.cls_head.num_classes = args.class_num 

            cfg.train_cfg.max_epochs = 30

            cfg.train_dataloader.num_workers = 8
            cfg.test_dataloader.num_workers = 8
            work_dir = osp.join(oripath, args.net, name)
            if not osp.exists(work_dir):
                os.system('mkdir -p ' + work_dir)
            if not osp.exists(work_dir):
                os.mkdir(work_dir)
            cfg.work_dir = work_dir
            runner = Runner.from_cfg(cfg)

            runner.train()

            runner.test()

     