# -*- coding: utf-8 -*-



import gym
from gym_minigrid.envs import Key, Ball, Box
from .verifier import *
from .levelgen import *
from gym_minigrid.register import register
from gym_minigrid.roomgrid import RoomGrid



class Level_TEST(RoomGridLevel):
    """
    Go to the red door
    (always unlocked, in the current room)
    Note: this level is intentionally meant for debugging and is
    intentionally kept very simple.
    """

    def __init__(self, seed=None):
        super().__init__(
            num_rows=1,
            num_cols=2,
            room_size=5,
            seed=seed
        )

    def gen_mission(self):
        obj, _ = self.add_door(0, 0, 0, 'red', locked=False)
        self.place_agent(0, 0)
        self.instrs = OpenInstr(ObjDesc('door', 'red'))


register_levels(__name__, globals())