## To run:

This code runs the base model DeepAR, our methods on the Traffic dataset

1. Install all dependencies listed in requirements.txt. The code has been tested with these exact versions.

2. Download the traffic dataset from https://archive.ics.uci.edu/ml/datasets/PEMS-SF. The zip file "PEMS-SF.zip" should be downloaded. Place the contents of the unzipped directory in data/traffic/. The following files should be present: PEMS_test, PEMS_testlabels, PEMS_train, PEMS_trainlabels, randperm, stations_list.

3. Preprocess the dataset in the format required for the model:

  ```bash
   python preprocess_traffic.py
  ```

4. Train DeepAR model. Default loss is set to the base model. To train with a different loss function modify the function name on line 233 of train_deepar.py

  ```bash
   python train_deepar.py
  ```  

5. The models are stored in experiments/base_model/ . To evaluate a model modify the experiment and model name on lines 398-399 of compute_metrics.py.

  ```bash
   python compute_metrics.py
  ```    
