# Taiming the Long Tail of Deep Probabilistic Forecasting

This repository corresponds to the official source code of the ICML 2022 submission


### Requirements
We use the same requirements as the Trajectron++EWTA, see:
https://github.com/lmb-freiburg/Contrastive-Future-Trajectory-Prediction

Please follow all the guidlines posted there first (cloning Trajectron++, obtaining data and pre-processing).

In order to augment Trajectron++EWTA to work with our methods please put ```train.py```, ```train_batch.py```, ```trajectronEWTA.py```, and ```mgcvaeEWTA.py``` in the main directory ```Contrastive-Future-Trajectory-Prediction```. ```argument_parser.py``` should be placed in ```Trajectron_plus_plus/trajectron/```.


### Training

Kurtosis Loss:

```
python train_batch.py --method kurtosis --device device_name --dataset dataset_name --kurtosis_weight 0.1 --model_name name_to_save
```
Pareto Loss Weighted:
```
python train_batch.py --method pareto_weighted --device device_name --dataset dataset_name --pareto_weight 1 --pareto_xi 0.1 --pareto_sigma 1 --model_name name_to_save
```
Pareto Loss Margin:
```
python train_batch.py --method pareto_margin --device device_name --dataset dataset_name --pareto_weight 1 --pareto_xi 0.1 --pareto_sigma 1 --model_name name_to_save
```

Where:

```dataset_name``` can be either ```nuscenes```, ```eth```, ```hotel```, ```univ```, ```zara1```, ```zara2```, or ```all``` (to train all 5 ETH-UCY models consecutively).

```device_name``` can be either ```cpu``` or specific gpu such as ```cuda:1```.