The dying Earth lay wrapped in its dismal coat of what was soon to be the complete darkness of a sunless world. Just as she no longer had the Moon, her Lamp of Ages, to light the night skies as she whirled on her course through the limitless ocean of Space, so now she was about to lose the Sun which, after billions of years, was at last burning out. Cold somber darkness of everlasting night was to engulf the eight planets to which old Sol had once given heat and light.

History tells of the Sun in all its glory, of a bright, warm Earth, of joy on the globe. It tells, too, of the moon, a shell set aglow by the sun's rays and reflecting on Earth the beauty of silvery light. But with the light from the sun growing more and more feeble through the preceding thousands of years, the Night's fixture had faded too until now it was no more than a dark body flitting past by day. Only at times during the night did a stray gleam of the sun illuminate, for a fleeting moment, the dead face, as a shadow passing across the white icecapes. Now there were only the stars, distant and aloof, smiling disdainfully upon the senile planet Earth, to light her night and her day too.

In Central City most of the few hundred thousands of people who now comprised the entire world's population had already gathered. The rest were hastening to join the multitude, so that together they might watch the sun in the throes of death. Then would they make their descent to the bowels of the Earth wherein the once proud Earthlings planned to make their last stand against their arch-enemy, Nature.

Kuila Rei was one of the tardy ones. As his name denoted, he was of the race of astronomers. He was the last to leave Mount 83 upon whose summit he and his fellow scientists had for many years kept the Sun under surveillance, publishing their minute calculations as to the hourly condition of the waning star.

Kuila, like many, objected strenuously to his removal to thousands of feet below the Earth's crust. He knew that several centuries before the Earth had been warned of the critical state of the Sun. Then had been the time for action. However, for the last million of years the Earth's people had been retrograding, and now except for a few hundred men and women of Kuila's ilk were mental and physical weaklings. They had been content to live on what their mighty ancestors had provided for them, using only what knowledge had come to them through the ages, and making no attempt to improve their condition.

Now through their lack of energy and foresight what machines they possessed were gradually wearing away. One by one those gigantic monsters, that had for thousands of years been producing all of man's needs, were breaking down because of the failure of their parts. From time to time men with some mechanical genius had repaired here and there. But, as the years went on, the knowledge of these men was lost until now the world was faced at last with the fact that they had practically no hope of succor from their present condition.

--- A Hope --- 

What they were to do when the last machine halted forever, when those machines would no longer turn out their barest necessities, they were not able to conceive. In fact, they gave no thought to the future at all. These simple-minded offsprings of the mechanical geniuses of the world existed, living on the fruits of the machines that produced foods, and materials from the air, as well as the soil, and from minerals dug from the Earth's core.

And now the Sun, from which much of the energy that drove these machines was obtained, was dying. The Sun would be a Sun no longer. It would become cool and perhaps foster new life in its tepid waters, life that would after ages crawl out upon a new as yet unlighted land.

However, as always in man's history, time and time again, it was in dire need that his supremacy eventually asserted itself. And such was now the case. A few men of stronger will and greater intellect had realized the state of affairs into which they were being plunged, and under their inspiration for the past fifteen years, a new activity had seized the Earthlings. Those who still possessed an understanding of mechanics were called forth. Together they built new machines out of the scraps of the old, and with these commenced digging night and day a shaft in the Earth that was to be the salvation of Mankind.

Without a doubt the Earthlings could not abide any longer on the surface of the Earth. Year after year great fields of ice had come down from the North-lands gradually encompassing the land, driving its peoples further and further into the South. They were increasing in such numbers that their cold was taking hold on the Earth and the Sun's weak rays could not stave them off. It would only be a question of time before the narrow belt at the equator that was alone untouched would be conquered by the Great Ice Flow.

There had been some talk of building machines that would carry them away from Mother Earth to a new planet and a new sun. But the wisest men knew the futility of such a course. True! History did tell of several such attempts; some had been successful, some not. Yet that had been in a day when men who understood such machines had lived, and they had not been built in a moment or day. To build ships that could bear them millions of miles through space was too difficult a feat for people who had just awakened from a lethargy in which they had dreamed and played for many centuries. For the present, only one course was open. Then when Man was more fully awakened, he might make other plans.

Already Man had reached the depth of almost a thousand miles below the surface. New machines were hollowing out great caves in the Earth's bowels in which the present population hoped to survive. The construction of the machines of the past now being studied from the records that remained, new discoveries were made and it looked as though Mankind were taking a new lease upon life.

After the first shaft had been driven, a second was started. It had been found that at this depth the temperature was a little below the normal heat required for the comfort of man, but until better provision could be made it would be necessary to make that do. Heating apparatus would be installed, lights, sewerage, everything to make the underground caves livable, and then with the years to come men would continue to dig deeper as the cold of the ice-coated Earth penetrated.

Giant caves were being hewn out of the living rock to house the five hundred-thousand souls that now made up the populace of the world. As each cave was dug it was lined with Ega, a glass-like substance that was sprayed from the mouth of a machine and which hardened into a hard, almost impregnable shell, and coated to a uniform thickness and smoothness.

For the present the sole idea was to provide room enough for the world's inhabitants to seek protection from the wretchedness and bitter chill of the Earth's surface. Everything must be upon a communistic basis; so many people allotted to each giant cave. Later small caves were to be hewn out for individual comfort and privacy, but that would take time.

Underground many obstacles barred their way. Subterranean rivers were a source of trouble and sometimes disaster to the diggers, but with their newly discovered ingenuity the workers learned to overcome and divert them to their own purposes. Sink holes, crumbling rocks and other calamities often retarded progress. But sometimes Mother Nature presented them with a few of the gifts that were still left in her cornucopia. There were natural caves, a deposit of precious metals, and barriers that fell without man's efforts.

--- Kuila Rei --- 

Thus had twenty great caves been dug out when at last word came from the astronomers that the Sun's power could not possibly survive the week. Night and day the work continued so that thousands might be made fairly comfortable. There was much lamenting on the Earth's crust as the world watched the fading of the Sun. It was hard enough to lose the warmth of the Sun, but to have to creep into the damp cellar of the Earth was almost too much for the soft men and women who had lived luxuriously under the shadow of mighty machines that had given them all.

Kuila Rei journeying in his flyer from the observatory wherein he had spent almost his whole life, since he had emerged from the City of the Children, thought of all this. The flyer had been built several thousand years before. Once it had been the very latest type of Lighter-than-Air machines that Science had produced. And it still was, for no better had been brought forth since. It sat like a bubble on the thin air of the globe, and in form it resembled a bubble. It was a perfect globe fashioned from a material that resembled glass, but its qualities were as different from that brittle, splintery material as night was unlike the day. Alu, the ancients called it, and it was as transparent as the air, yet as strong as Earth itself, malleable as clay and lighter than air. The greatest weight could not smash or crush it, the sharpest point could not even scratch its surface.

Within this indestructible chamber sat Kuila Rei on a seat covered with a leathery material whose back could be let down for sleeping purposes. His feet rested on a similar pad and on a bar in front of him that extended from side to side were placed the various levers that controlled the machine. Under the seat was fitted the motor contained in a small metal box, taking up no more than a cubic foot of space. The oxygen tank twice the size of the motor stood near by.

Flying thousands of feet above the ground Man had found that the thinning atmosphere was too rare and each flyer was consequently supplied with its own oxygen tank containing enough of the precious gas to sustain the pilot for one hundred hours. An open valve in the side of the globe allowed enough of the poor grade of air to flow from the outside to the tank and thence into the globe reviving the air sufficiently to the proper proportions needed for the driver. The motor, ingenious and yet of a marvelous simplicity, used for its fuel the carbon dioxide expelled by the occupant of the machine, thus also keeping the air clean and fresh. Through another vent the motor tossed off its waste.

On entering his flyer Kuila had set the indicator for Central City, and turned the height gauge to the altitude he knew it best to fly. He had no more to do but wait until he arrived at his destination. Had he been able to see the ground over which he was flying, at a height necessary to avoid the irregularities of the Earth's surface, he would not have been interested in the least. For where ages before had flourished beautiful trees and wild jungle verdure; where jeweled pools had lay dimpling in the sun; where brilliant birds and chattering monkeys had lived joyously (in that part of the world that had once been called Brazil) there was nothing now other than a wasteland, grey, bleak and cold, its face like the worn, wrinkled visage of the old.

Kuila had with him a collection of ancient books and archives that he had discovered during his life. Many hours he had studied them, and in those hours he had lived not in the barren world of today, but in the beautiful sunlit years that had gone before. In his books he had read of the glory of the sun, of the vast, ever-moving waters (all ice now), of green happy lands, of the moon that had once lighted the sky at night. Ah! if only he could journey to a world that was as fresh and young!

Not until he felt the growing stuffiness in his machine, due to the accumulation of carbon dioxide no longer being used by his motor, did he realize that he had come to a stop, and that he was floating like a bubble over the city.

Like every man-made structure that still existed Central City had been built in the far-off past. Here had been the core of the once-great realm of the Earth. Here sat the Five, scientists all, who directed the welfare of mankind. Here had the greatest of men lived. Building after building rose thousands of feet in the air, each building an entire community in itself, joined to its neighbors by numberless airways for both pedestrians, ground and air cars. Several great arteries were still used by the small population of the city. But for the most part the city that had once housed thirty millions lay as dead, the skyscrapers untenanted and cold; although to this day there was no sign of decay. One could pass from chamber to chamber and find the belongings of their past owners neatly in order. The decay of the race had been gradual. There had been no hurried flight. Only the slow disintegration of a well-satisfied people.

Kuila Rei maneuvered his flyer gently down the roof of perhaps the most gigantic skyscraper in the city. As he drew near he saw that the roofs of the surrounding buildings, as well as the one to which he was descending, were crowded with people. Room was cleared for his machine close to the hangar and a small group detached themselves to aid him in pushing the machine under cover.

An aged man standing near by spoke to him. "It is the last time you shall fly through the air of this condemned world, O Rei," he murmured and sighed. Kuila scowled at the reminder of that fact, and pushed himself into the heart of the crowd. He found his way to one of the kiosks that housed an elevator and stepping in it he pressed the indicator for a floor a thousand feet below.

The drop occupied less than a minute and he was in a corridor. He hurried along to an office wherein several people were still lingering. In the center of the room stood a machine with a mouthpiece on its face, and into this he dictated his report. He stated his name, age and occupation and explained that he had been the last to leave the observatory of Mount 83; that it was in perfect condition, a condition, he conjectured that would withstand the ice-flow that was slowly surmounting the peak on which the observatory stood. His report ended, he turned away. He knew that the machine would relay his report to an adjoining office, write it in indelible print on a thin metal sheet and file it away with similar reports in alphabetical and chronological order.

--- A Beautiful Companion --- 

With that done he left the office, returning to the shaft by which he descended. A girl was walking ahead of him, and they both reached the lift almost at the same moment. She was dressed exactly as Kuila Rei, and on her shoulder he descried insignia the same as he wore, the insignia of the astronomers.

The suits of the Earthlings were made of a material that transmitted no heat, holding the normal body heat of the wearer. It was in two pieces, blouse and trousers. The trousers almost skin-tight fitted snugly at the hips. They were designed so as to contain the feet; and under the feet were sewn heavy pieces of felt that fitted the foot. The blouse was loose to give free movement to the torso. It fell straight from the shoulder half-way to the thighs and was caught tightly at the waist with a girdle. The sleeves hung rather full from shoulder to wrist and were buckled tightly; while the collar, rather high, fitted the neck closely. From the shoulders hung a hood that could be pulled over the head and fitted tightly about the face and chin. From it a mask could be drawn over the face to protect it in cases of extreme cold and to the mask were fastened small tubes for nose and mouth. These could be attached to an oxygen tank that the wearer would carry on his shoulders. Gloves were carried in one of the slit pockets of the blouse.

Kuila followed the girl into the elevator and they came face to face. He was struck by the exquisite beauty of her clear features, a beauty that was striking even among a people who were all beautiful. Her skin was a warm olive, a complexion that had been evolved from the admixture of the five original races upon Earth. Her eyes were clear hazel, her lips a deep red. Each feature was as perfect as though hand-chiseled, from the little square chin to the fine sensitive eyebrows and smooth white temples. And framing it all was the hair of a rich blackness. Once human hair entailed the constant need of trimming, but Science had easily done away with that inconvenience by the simple means of the T-Ray. When the T-Ray was trained on the hair and beard by means of a cap-shaped helmet it not only halted the natural growth of the roots but at the same time treated them so that in a life-time not a single hair could fall from the scalp.

In response to his smile the girl smiled back brightly. "I suppose we are both ascending to the roof?" she queried in a low well-modulated voice that was strangely thrilling to a man who had not heard a woman's voice in over ten years. He nodded, and she touched the lever that should carry them upward.

The lift traveled fast, but in the thousand foot ascent there was still time for Kuila Rei to learn that the girl was Ramo Rei; that she had returned from Mount 47 whereupon was set an observatory like the one he had just left; that she had been associated only with two woman and two men, all of whom had already passed the third cycle (150 years of age); and so therefore, she had taken no companion (mate) and was, like himself, quite alone in the new world they were to enter.

They were not immediately aware that the elevator had stopped. Only when the steady murmur of voices came to them from without did they suddenly realize they had reached the roof. Kuila managed to elbow his way through the crowd and found for them an unoccupied spot in a secluded part of the parapet.

It was now almost time for rising of the sun. Once, the annals of history showed, the Earth had known approximately twelve hours of day-light. But gradually, through the ages, the periods of day had grown shorter until now at the present time there was scarcely one short hour of light. This was due to the fact that the Sun was no longer a ball of fire, that only two spots still burned on its wide expanses. A month since the smaller of the two spots had burned out, and now it was but a question of hours before the other spot would give its last flicker.

A stillness pervaded the towering roofs and here and there a few groups could be seen whispering. On the left was the building now occupied by the twenty-seven thousand children who had been brought from the City of Children and their sweet fresh voices could be heard in song as they greeted the wan light. Almost a billion years ago the ancestors of these children had sung in the same manner to the sun to give them light and keep them in health.

In their corner Ramo and Kuila were speaking in subdued tones. There was much for them to tell each other, and the affinity which had drawn them together was strengthened as they learned that they had many interests in common. She, too, had gathered books of the past, and they both longed to see a sun in all its wonder and to feel its warmth surge through their veins.

"I contend," said Kuila, "that we make a mistake in descending to the Earth's core. It would be far better that we migrate to another Universe which has a sun that is still young!"

He saw the light that came into her eyes at his words. She nodded her head in approbation. "I, too, Kuila Rei, have had such dreams. At night when I was alone at the sky-eyes I studied the various planets and Universes for the possibility of transferring ourselves to another world. Buik Rei, head astronomer of Mount 47, and I have studied the proposition from all angles and he agrees it is feasible. Only we are not yet equipped for such an expedition. Long ago we might have profited by the knowledge of our forefathers and traversed Space at will. Now, instead, we must begin all over again to learn what they had so gladly prepared for us."

"Then you do believe there is a possibility?"

"Is anything impossible?"

Further discussion was halted at that moment by the cry that had gone up from the five hundred-thousand Earthlings gathered on the roof-tops. There had been a change in the somber darkness enclosing them; a pale grayish light was now visible in the Eastern sky!

"The Sun, the blessed Sun!" cried the voices.

Gradually the light became brighter, and then on the Eastern horizon appeared the sun, but Oh! so different from the old bright sun.

Once it had been globe-shape, dazzling bright, so that the eyes could not look upon it. Now, all that remained of the old fire was one strange, ragged streak of light that ran vertically up the surface of the globe, and so weak and feeble was that single streak that it looked wan and livid. There was no rosy haze to accompany this dawn. All was gray, stark, nude.

The hour was passing—and, as they watched, the onlookers could see that the white streak that was the sun was gradually turning on its axis so that the single burning spot would soon be hidden from sight of those on Earth. And it would be many, many hours before the Earthlings would catch sight of it again. The grayness was gradually fading into darkness again. The myriad of stars overhead continued to gleam, sparkling in all their splendor, twinkling like the eyes of a man overcome by laughter—laughing at the plight of a doomed world.

With sighs and low murmurings the crowds dispersed from the rooms. Ramo and Kuila did not leave yet. The Earth may grow senile, but youth tells the same old story. And the two had much to tell each other. Astronomers both, they spoke the same language, had the same hopes and desires. And then, they were young.

Two hours later they agreed to descend from the roof. As they had just arrived in the city neither had taken up new quarters as yet, and they went down to the office where they would be assigned quarters. They had but to speak their name, number, and rating into a machine like the one to which they had already reported, and in answer came a small piece of circular metal having upon it, in the strange numerical writing of that day, their new address.

Each giant building was a city in itself. Each had its auditorium where gathered for general announcements, amusements, lectures and discussions, the tenants of the building. There were large conservatories where was planted what verdure and vegetation had been preserved through the centuries. A few birds and smaller animals had been kept alive in the same manner. Canned sunlight, the light of the sun that had been gathered by scientists many years before and stored in giant vats, took the place of the ineffectual sun. Here people spent much of their time.

--- The Home of the Five --- 

Another floor was devoted entirely to a commissary to provide the building with its necessities. Three entire floors were devoted to the offices that recorded automatically every small detail in the life of its tenants. The remaining floors were given over to living quarters. This particular building which now housed Kuila and Ramo was the Scientific Building, and herein dwelt all those who belonged to one branch or another of Science.

Once every building in the city had been filled to capacity and there had been a continual overflowing into new buildings—but in the centuries that had just preceded this, the population of the world had diminished so greatly that city after city had been deserted until only Central City and the City of Children were inhabited.

In Central City there was one building that differed from the others. This odd building formed the nucleus of the city and was reckoned for that matter the center of the world. For from it emanated the life of the world and its government. It was the residence of The Five.

Many millions of years before Four Scientists had revolutionized the civilized world. They had previsioned a world subjugated by the yellow race, and to avoid that they had overthrown the entire world, destroyed its antiquated civilization and set up a new government with Scientists at the head instead of kings. Only by the effort of a young man was a catastrophe that would have entirely depopulated the world, averted. Thereafter the youth was added to the Quaternion so that henceforth it became a Quinvate and had continued so to this day.

The Five were sufficient unto themselves, directing the destinies of their world, choosing from each generation a new member to succeed the old and governed only by their high sense of duty to their fellow-man. As the new member was recruited from the younger generation, he (or she for sex made no difference) was taught the high principles of the order, bringing with him a fresh sense of justice and knowledge of the world he had been a part of. Thence he studied with his elders, so that, when he was aged and called upon a youth to succeed him, he had much to impart. As the man was sure to live well past his two hundredth year he had great knowledge, experience and understanding to pass on to his juniors.

The building that housed the Five was only ten stories high. One floor was given over to a common council chamber; the second to private council rooms, rooms for the guards, and offices. Two more floors were laboratories, and might be likened to a patent office where all new inventions, new innovations were investigated, tried and proven, as to their practicability. Here the various members of the Five spent much of their own time working, improving, giving the products of their own minds to civilization. The next five floors belonged to the Five exclusively. Here they had privacy, each having one entire floor for himself and his attendants. The tenth floor was their mutual meeting ground. Here was their common lounge and their conservatory. They also had a roof promenade, but that was covered over with unbreakable glass and guards passed up and down day and night.

The Five dressed exactly as did their fellow-men, without mark of distinction. Only with them the mask was always worn over the face and they never moved about unless under heavy guard. When once a man or woman took the sacred oath of the Quinvate all ties were cut. Friends were forgotten, mother and father they had never known, mates were discarded like all else. Thus, once in a generation, a fellow being might drop out of his sphere never to be seen again. One-time friends may conjecture that he who had so excelled in his line of endeavor had reached the zenith and had been chosen by the Five. But one could never be positive. Perhaps the friend had been transferred to a station across the world, to carry on their work as heretofore. Hence the mask, that none might claim friendship with any member of the Five, and retard the wheels of justice. For first of all the Five were the judges to decree life and death!

Once some fanatic who imagined an enemy of his to have been elevated to that high position had, with an infernal machine, managed to almost demolish the Center, killing two of the Five. That was the greatest catastrophe to have happened to them, and it took years to recover from the effects. It took vigilance and extreme care to prevent the recurrence of that same action.

For the past several thousand centuries the Five had not been the august body as heretofore. Recruited from a decaying race they had been merely representative of it. However, it was through the efforts of the newest recruit that the program of today was brought about; that the new machinery had been brought into being; that new heart was taken by the populace.

After receiving the cards with their room numbers upon them, Ramo Rei and Kuila Rei separated and agreed to meet again and go together to the Council Chamber where a meeting was scheduled to take place in ten hours.

--- Last Hours --- 

Kuila repaired to the room given him—identical to all other living rooms in Central City. In measurement the room was fifteen by fifteen and twelve feet high. At first glance the walls were a buff color, but after a few moments in the room under the glow of the light that appeared to emanate from the walls themselves it was evident that they were changing color. A pink flush was creeping over them, a pink that deepened to a rose to be saved from red by the appearance of another hue, a delicate blue, that, from dark blue, became a light green and so through the spectrum of colors. Ages ago Man had discovered the effects of color upon his nervous system and knew that the monotony of any one shade would eventually drive him mad. Therefore, as one by one the colors of Nature disappeared around him, he set about producing a riot of color about him. Everything he made was colored with a pigment which in the light brought out the seven colors and all the delicate shades between them. Even clothes had the faculty to change minutely.

In shape the room was square, and yet the corners were built with a curve that gave the room a graceful line. Its furnishings were of the simplest. There were low couches padded with a soft felt-like material, and like the walls, it changed color continually. These couches, fashioned so as to give perfect ease to the body, were shaped to its curves and angularities, and were used both as beds as well as for relaxation, serving for the awkward chair of the ancient. Several low tables, hardly a foot high, served as desks or to hold a few simple though colorful ornaments.

One wall of the room was given almost entirely over to a large mirror-like surface that gave no reflection. But by touching a small lever on its side it gave the onlooker all the news of the world—like the news-reel of old, by which ages ago one might sit back and watch the progress of the world. A simple attachment gave forth sound so that music, lectures and various sound arrangements came to the listener. Now men seldom used this medium, for, in a world that comprised only two cities and a few outposts, there was little news to broadcast besides that which went by word of mouth or could be announced in the city streets and auditoriums.

Adjoining the single room was a small bathroom with all its necessary features, and on the far side of the room was a small closet. Herein were three faucets and a cupboard. One faucet gave water, and the other two faucets each emitted a liquid food that was the mainstay of the Earth's thousands. Once man ate the flesh of animals, but animals, as well as leaves, fruits and roots of grasses and vegetation had passed away. Man had discovered thereafter that the food products of trees, and later of minerals, were even more highly efficient, and though Man lost sense of taste he gained a better store of body energy. The machinery that produced the tasteless liquids also brought forth cubes of highly concentrated food that was preserved in this manner for indefinite periods. And, as one cube a day together with a measure of liquid is sufficient for the human, it was possible to carry several months' supply on one's person without taking up much space. Consequently the pleasure of eating had been lost, but the tripled efficiency of the food overcame that loss.

Kuila Rei drew a glass of the colorless liquid that was hot to the taste; and then threw himself on a couch. He did not sleep immediately, dreaming rather of the girl he had just left. Soon, however, sleep claimed him. He was awakened by a metallic voice near at hand, coming from a small instrument on one of the nearby tables, that informed him that the hour of meeting in the Auditorium was at hand.

He found Ramo Rei at the place they had named for their tryst, and together the pair took their places on the benches arranged to seat the several thousand the building was housing. They were addressed by an official who spoke of what the machines had been doing in the bowels of the Earth; of what they would find in their new home; of what would be the duty of every man and woman. It was not a beautiful prospect he painted for them, but then there was no reason to paint the picture any brighter than it was. He explained that everyone was to carry on the type of work that he was accustomed to atop the Earth, and for those whose type of employment would be of no use under the Earth's crust, new work should be found.

Ramo and Kuila turned to each other with a question. What could they, the astronomers, do now? It would take years before shafts could be dug through the earth back to the summits of the mountains whereon stood the observatories. Well, whatever might come, it was certain that the twain would stick together.

They went into a conservatory and strolled there together for hours. Then, when the hour of dawn was again at hand, they repaired to the roof. Two more days passed in the same manner, and on the third day word was noised about that the last hour was at hand. The Sun was in its death throes.

The two went to their place at the parapet. The crowds were silent now, holding their breath. Gradually the sky was becoming gray, but a sickly gray, watery and pale. Nothing was distinct in the poor light. Eyes strained to catch the first glow of the single flame of light, and a volume of sound went up when at last it appeared.

Its light was very faint, so faint that it was no brighter than the glow of a distant star. Then suddenly it all changed. It grew brighter and brighter. That streak of red growing brighter, still brighter. It suddenly looked as if the whole star was aflame again. Who said the Sun was dying? A cry went up from the roof-tops. The multitude could feel the warmth from that bright fire.


Brighter, ever brighter, a single flame pushed out. The Sun was dying, and that light was its last burst of glory. A death-like silence settled over the multitude.

Brighter, ever brighter, a single flame pushed out, reaching out, growing, brighter and brighter. Some one screamed. "That flame ... the Sun is coming to consume us! Hail O Sun, take us to your heart, devour us in your last burst of glory!"

The flame, however, appeared to have spent itself, it was dwindling once more. The Sun was dying. That burst of light had been the Sun's last burst of glory. Low murmurings arose from the crowds, someone commenced to sing a dirge and all took it up as they watched the flame growing smaller, smaller. Then the light was gone. Only a faint grayness persisted, but that too died. Several minutes more and the darkness gathered in, a darkness that was never to be dispelled again.

--- Into the Depths --- 

The stars seemed creeping closer so that they might see and jeer at Mother Earth. A voice broke loose from the roof-tops again. "Come let us creep like ants into our holes, and burrow into the heart of our Mother. Come, come you poor weak things that proudly term yourself Man, Lord of the Universe. Creep into the darkness. Come now, out of this bitter coldness that would grasp you by the throat. Come, all of you, who would play at living. Come!"

A death-like silence settled over the multitude. Then voices were heard again, whisperings and comfortings, and a wail that grew in volume until it seemed to encircle the Earth. The cry of a people forsaken, broken. On the roof of one building a commotion started, then a yell and a scream and a body went hurtling over the roof, down the several thousand feet to the ground. Another followed, and another as men and women despairingly threw themselves over the parapets. More might have followed had not a figure of command appeared on the highest pinnacle of the roof of the Scientific Building.

"Come! To the lifts! We descend to our new home, my people!" he cried out. "Come! New life awaits us. Come!"

In answer the crowds became milling masses as they made their way to the elevators. Forgotten were the weaklings who could not face life any longer. And those who had thought to do the same turned instead to the voice of command.

Ramo and Kuila were amongst the last to descend. They had been as breathless as their fellow-men at the appearance of the Sun, and its last supreme effort. And with its dying Ramo had hidden her face in her hands. Somehow Kuila had found his arm around her, and she had laid her head on his breast while she sobbed.

But even though the Sun had died, and the last hope of Earth departed, Kuila found himself happy, happier than he had ever known. For now he knew