from prover.utils import AttrDict
from prover.algorithms import Sampling

# dataset
data_split = ['train']
data_repeat = 1

# verifier
lean_max_concurrent_requests = 8
lean_memory_limit = 10
lean_timeout = 120

# model
batch_size = 4
mode = 'cot_kimina' # `cot` or `non_cot`
pass_ = 32
model_path = 'AI-MO/Kimina-Prover-Preview-Distill-7B'
# max_model_len = 8192

model_args = AttrDict(
    mode=mode,  
    temperature=0.6,
    max_tokens=15000,
    top_p=0.95,
)

# algorithm
n_search_procs = 32
sampler = dict(
    algorithm=Sampling,
    sample_num=pass_,
    log_interval=32,
)