# Template-free Articulated Neural Point Clouds for Reposable View Synthesis

**Note that the code base is not cleaned up yet, and that a final version will be made available at [https://github.com/lukasuz/Articulated-Point-NeRF](https://github.com/lukasuz/Articulated-Point-NeRF).**

We briefly describe how to set up the repository such that the jumping jacks scene from the Blender data set can be trained.


## Installation
Please first install **Pytorch** and **torch_scatter** manually, as they are machine dependent. We used python version 3.9.12. Then:
```
pip install -r requirements.txt
```
**Dependencies**:

  - `PyTorch`
  - `numpy` 
  - `torch_scatter`
  - `scipy`
  - `lpips`
  - `tqdm`
  - `mmcv`
  - `opencv-python`
  - `imageio`
  - `imageio-ffmpeg`
  - `Ninja`
  - `einops`
  - `torch_efficient_distloss`
  - `pykeops`
  - `tensorboardX`
  - `seaborn`
  - `scikit-image`
  - `torchvision`
  - `scipy`
  - `connected-components-3d`
  - `pandas`
  - `roma`


If any unexpected problems should arise while setting up the repository, you can further consult DVGO [0] or TiNeuVox [1] as we are heavily lending from their code base.

## Data Preparation
**Blender Dataset:** 

The D-NeRF dataset has to be downloaded, in this case the juming jacks scene. This dataset is publicly available. Then organize your dataset as follows.

```
├── data 
│   ├── jumpingjacks
│   ├── ...
```

## Running the Experiment
To run the experiment suit for the Jumping Jacks scene, execute the train_nerf.sh script
``` bash
./run_experiments.sh
```
Otherwise python scripts separately, as shown below.

1. Train TiNeuVox:

``` bash
python run.py --config configs/nerf/jumpingjacks.py --i_print 1000 --render_video --first_stage_only
```

2. Extract point cloud, skeleton, and train second stage *(This will also render the reconstructed scene over time)*:

``` bash
python run.py --config configs/nerf/jumpingjacks.py --i_print 1000 --render_video --second_stage_only --render_pcd
```

3. To render the video after skeleton simplification, pass the degree_threshold parameter:

``` bash
python run.py --config configs/nerf/jumpingjacks.py --i_print 1000 --render_video --second_stage_only --render_pcd --degree_threshold 20
```

4. Run test set evaluation:

``` bash
python run.py --config configs/nerf/jumpingjacks.py --render_only --second_stage_only --render_pcd --render_test  --eval_psnr --eval_ssim --eval_lpips_alex --eval_lpips_vgg --load_test_val
```


## References

[0] DVGO:

```
@inproceedings{sun2022direct,
  title={Direct voxel grid optimization: Super-fast convergence for radiance fields reconstruction},
  author={Sun, Cheng and Sun, Min and Chen, Hwann-Tzong},
  booktitle={Proceedings of the IEEE/CVF Conference on Computer Vision and Pattern Recognition},
  pages={5459--5469},
  year={2022}
}
```

[1] TiNeuVox:

```
@inproceedings{fang2022fast,
  title={Fast dynamic radiance fields with time-aware neural voxels},
  author={Fang, Jiemin and Yi, Taoran and Wang, Xinggang and Xie, Lingxi and Zhang, Xiaopeng and Liu, Wenyu and Nie{\ss}ner, Matthias and Tian, Qi},
  booktitle={SIGGRAPH Asia 2022 Conference Papers},
  pages={1--9},
  year={2022}
}
```