from copy import deepcopy

expname = None                    # experiment name
basedir = './logs/'               # where to store ckpts and logs

''' Template of data options
'''
data = dict(
    datadir=None,                 # path to dataset root folder
    dataset_type=None,            
    load2gpu_on_the_fly=True,    # do not load all images into gpu (to save gpu memory)
    testskip=1,                   # subsample testset to preview results
    white_bkgd=False,             # use white background (note that some dataset don't provide alpha and with blended bg color)
    half_res=True,              
    factor=4,                     
    ndc=False,                    # use ndc coordinate (only for forward-facing; not support yet)
    spherify=False,               # inward-facing
    llffhold=8,                   # testsplit
    load_depths=False,            # load depth
    use_bg_points=False,
    add_cam=False,
)

''' Template of training options
'''
train_config = dict(
    N_iters=20000,                # number of optimization steps
    N_rand=4096,                  # batch size (number of random rays per optimization step)
    lrate_feature=8e-2,           # lr of  voxel grid
    lrate_featurenet=8e-4,
    lrate_deformation_net=6e-4,
    lrate_forward_warp=6e-4,
    lrate_densitynet=8e-4,
    lrate_timenet=8e-4,
    lrate_rgbnet=8e-4,           # lr of the mlp  
    lrate_decay=20,               # lr decay by 0.1 after every lrate_decay*1000 steps
    ray_sampler='in_maskcache',        # ray sampling strategies
    weight_main=1.0,              # weight of photometric loss
    weight_entropy_last=0.001,
    weight_rgbper=0.01,            # weight of per-point rgb loss
    tv_every=1,                   # count total variation loss every tv_every step
    tv_after=0,                   # count total variation loss from tv_from step
    tv_before=1e9,                   # count total variation before the given number of iterations
    tv_feature_before=10000,            # count total variation densely before the given number of iterations
    weight_tv_feature=0,
    pg_scale=[2000, 4000, 6000],
    weight_distortion=5e-2,
    weight_inv=0,
    weight_delta=0,
    weight_mask_loss=0,
    skip_zero_grad_fields=['feature'],
    unobserved_view_reg=False
)

''' Template of model and rendering options
'''

model_and_render = dict(
    num_voxels=160**3,          # expected number of voxel
    num_voxels_base=160**3,      # to rescale delta distance
    voxel_dim=12,                 # feature voxel grid dim
    defor_depth=5,               # depth of the deformation MLP 
    net_width=128,             # width of the  MLP
    alpha_init=1e-3,              # set the alpha values everywhere at the begin of training
    fast_color_thres=1e-4,           # threshold of alpha value to skip the fine stage sampled point
    stepsize=0.5,                 # sampling stepsize in volume rendering
    world_bound_scale=1.05,
    no_view_dir=False
)

N_iters = 160000
after_train_iter = N_iters - (N_iters // 10)
after_train_iter = 2000000
pcd_train_config = dict(
    pose_one_each=True,
    load_3DConv=False,
    kinematic_warp=True,
    N_iters=N_iters,
    weight_merge_iter=10000000,
    pre_train_iter=0,
    conv_render_until=0,
    full_t_iter=N_iters // 2,
    after_train_iter=after_train_iter, #160000 // 2
    pre_train_t_num=10,
    lrate_decay= N_iters // 1000,
    rho_c=None,
    lrate_rgbnet=1e-4,
    lrate_densitynet=1e-4,
    lrate_featurenet=1e-4,
    lrate_canonical_feat=1e-4,
    lrate_gammas=1e-3,
    lrate_deformation_net=0,
    # Points
    lrate_weights=1e-4, # 1e-4
    lrate_theta_weight=1e-4,
    lrate_forward_warp=1e-4, #1e-2
    lrate_joints=5e-5, # 1e-4
    lrate_theta=1e-5,
    lrate_feat_net=1e-3,
    skip_zero_grad_fields=[],

    weight_render=2e+2, # 1e-1
    weight_chamfer2D=2e-2, #1e-1
    
    # Regularizers
    weight_joint_chamfer=1,
    weight_transformation_reg=1e-1, #1e-2
    weight_tv=1e+1, # 1e-6
    weight_sparsity=1e-1, #1e-2

    # Old stuff
    weight_arap=0,
    weight_joint_arap=0,
    weight_scene_flow_tv=0,
    weight_flow_diff=0,
    weight_optical_flow=0,
    weight_we_entropy=0,
    weight_teacher=0,
    weight_time_tv=0,
    weight_chamfer=0,
    weight_mask_loss=0,
    weight_collision_loss=0,
    weight_feat_consistency = 0,

    avg_procrustes=False,
    over_parameterized_rot=True,
    use_global_view_dir=False,
    use_direct_loss=False,
    ray_sampler='random',
    embedding='full',
    N_rand=4096 * 2
)

pcd_model_and_render = dict(
    stepsize=0.5,
    world_bound_scale=1.05,
    fast_color_thres=1e-4,
    bone_length=10.,
    pcd_density_threshold=0.05,
    canonical_pcd_num=1e+4,
    other_pcd_num=5e+3,
    degree_threshold=0
)

del deepcopy
