#!/bin/bash
export CUDA_VISIBLE_DEVICES=1
ep=80
model_name=SOR_Mamba

lp=0
lamb=0.001
python -u run_SSL_FT.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS04.npz \
  --model_id PEMS04_96_12 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len 96 \
  --pred_len 12 \
  --e_layers 4 \
  --enc_in 307 \
  --dec_in 307 \
  --c_out 307 \
  --des 'Exp' \
  --d_model 1024 \
  --d_ff 1024 \
  --learning_rate 0.0003 \
  --itr 1 \
  --lamb $lamb\
  --train_epochs $ep\
  --learning_rate_alpha 0.2\
  --lp $lp\
  --use_norm 0

python -u run_SSL_FT.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS04.npz \
  --model_id PEMS04_96_24 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len 96 \
  --pred_len 24 \
  --e_layers 4 \
  --enc_in 307 \
  --dec_in 307 \
  --c_out 307 \
  --des 'Exp' \
  --d_model 1024 \
  --d_ff 1024 \
  --learning_rate 0.0003 \
  --itr 1 \
  --lamb $lamb\
  --train_epochs $ep\
  --learning_rate_alpha 0.2\
  --lp $lp\
  --use_norm 0

python -u run_SSL_FT.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS04.npz \
  --model_id PEMS04_96_48 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len 96 \
  --pred_len 48 \
  --e_layers 4 \
  --enc_in 307 \
  --dec_in 307 \
  --c_out 307 \
  --des 'Exp' \
  --d_model 1024 \
  --d_ff 1024 \
  --learning_rate 0.0003 \
  --itr 1 \
  --lamb $lamb\
  --train_epochs $ep\
  --learning_rate_alpha 0.5\
  --lp $lp\
  --use_norm 0

python -u run_SSL_FT.py \
  --is_training 1 \
  --root_path ./dataset/PEMS/ \
  --data_path PEMS04.npz \
  --model_id PEMS04_96_96 \
  --model $model_name \
  --data PEMS \
  --features M \
  --seq_len 96 \
  --pred_len 96 \
  --e_layers 4 \
  --enc_in 307 \
  --dec_in 307 \
  --c_out 307 \
  --des 'Exp' \
  --d_model 1024 \
  --d_ff 1024 \
  --learning_rate 0.0003 \
  --lamb $lamb\
  --train_epochs $ep\
  --learning_rate_alpha 0.5\
  --lp $lp\
  --itr 1 \
  --use_norm 0