import os


def get_hemisphere_labels():
    freesurfer_home = os.environ.get("FREESURFER_HOME")
    path_lut = os.path.join(freesurfer_home, "FreeSurferColorLUT.txt")

    left_labels = []
    right_labels = []

    with open(path_lut, 'r') as f:
        for line in f:
            if line.startswith('#') or not line.strip():
                continue
            parts = line.strip().split()
            if len(parts) < 2:
                continue
            try:
                label_num = int(parts[0])
                label_name = parts[1].lower()
            except ValueError:
                continue

            is_left = (label_name.startswith("left-") or
                       label_name.startswith("lh_"))
            is_right = (label_name.startswith("right-") or
                        label_name.startswith("rh_"))

            if is_left:
                left_labels.append(label_num)
            elif is_right:
                right_labels.append(label_num)

    return left_labels, right_labels
