import os
import cortex


def main():
    path_datasets = ...
    assert os.path.exists(path_datasets), path_datasets

    dict_datasets = {
        'THINGS-fMRI': ['S1', 'S2', 'S3'],
        'BOLD5000': ['CSI1', 'CSI2', 'CSI3', 'CSI4'],
    }
s
    for dataset, subject_ids in dict_datasets.items():
        path_dataset = os.path.join(path_datasets, dataset)
        assert os.path.exists(path_dataset), path_dataset

        path_freesurfer = os.path.join(path_dataset, 'freesurfer')
        assert os.path.exists(path_freesurfer), path_freesurfer

        for subject_id in subject_ids:
            for hemi in ['lh', 'rh']:
                cortex.segment.cut_surface(subject_id, hemi, fs_subject_dir=path_freesurfer)
            path_brainmask = os.path.join(path_dataset, 'processed', subject_id, 'brainmasks', f'{subject_id}_brainmask.nii.gz')
            assert os.path.exists(path_brainmask), path_brainmask
            cortex.align.automatic(subject_id, 'align_auto', path_brainmask)




if __name__ == '__main__':
    main()
