import numpy as np
from scipy.spatial.distance import squareform
from scipy.cluster.hierarchy import linkage, fcluster
from sklearn.metrics.pairwise import cosine_similarity


def cluster_embeddings(embeddings, num_clusters=10, method='ward'):
    similarity = cosine_similarity(embeddings)
    dissimilarity = squareform(1 - similarity, checks=False)
    Z = linkage(dissimilarity, method)

    labels = fcluster(Z, num_clusters, criterion='maxclust') - 1
    sorted_labels = np.argsort(labels)

    return sorted_labels
