import numpy as np
from skdim.id import lPCA, MLE


class Dimensionality:
    @staticmethod
    def effective_dimensionality(data, ver='participation_ratio'):
        if data.ndim > 2:
            data = data.reshape(data.shape[0], -1)
        lpca = lPCA(ver=ver).fit(data)
        return lpca.dimension_

    @staticmethod
    def intrinsic_dimensionality(data, num_neighbors=20, num_jobs=-1):
        if data.ndim > 2:
            data = data.reshape(data.shape[0], -1)
        mle = MLE().fit(data, n_neighbors=num_neighbors, n_jobs=num_jobs)
        return mle.dimension_
