import os
from pathlib import Path

MAIN_DIR = "" # should be set to the path of the main directory
LOG_PATH = "" # should be set to the path of the log directory
STAT_PATH = "" # should be set to the path of the stats directory
CODE_PATH = Path(os.getcwd())
CONFIG_PATH = CODE_PATH / "config"

# paths to certain dataset
PDEBench_PATH = ""  # should be set to the path of the PDEBench dataset
SFEULER_PATH = ""  # should be set to the path of the shearflow and euler datasets
DATA_PATHS = {
    'burgers': [PDEBench_PATH + '/1D/Burgers/Train', 'burgers', '', '1024x1'],
    'swe': [PDEBench_PATH + '/2D/shallow-water', 'swe', '', '128x128'],
    'diffre2d': [PDEBench_PATH + '/2D/diffusion-reaction', 'diffre2d', '', '128x128'],
    'incompNS': [PDEBench_PATH + '/2D/NS_incom', 'incompNS', '', '128x128'],
    'compNS128': [PDEBench_PATH + '/2D/CFD/2D_Train_Rand', 'compNS', '128', '128x128'],
    'compNS512': [PDEBench_PATH + '//2D/CFD/2D_Train_Rand', 'compNS', '512', '128x128'],
    'compNS': [PDEBench_PATH + '//2D/CFD/2D_Train_Turb', 'compNS', '', '128x128'],
    'shearflow': [SFEULER_PATH, 'shear_flow', '128x256', []],
    'euler': [SFEULER_PATH, 'euler_multi_quadrants_periodicBC', '128x128', []],
}

MODEL_NAMES = {
    'burgers': [
        'FINAL_TF_burgers_lrm1',
        'FINAL_oml_burgers_VI_lrm1_k11',  # effectively _k5
    ],
    'diffre2d': [
        'FINAL_TF_diffre2d_lrm1_es400',
        'FINAL_oml_diffre2d_VII_lr0m1',
    ],
    'incompNS': [
        'FINAL_TF_incompNS_lrm1',
        'FINAL_oml_incompNS_VII_lrm1_k5',
    ],
    'shearflow': [
        'FINAL_TF_sf_lrm1_es400_circ',
        'FINAL_oml_sf_lr0m1_es400_circ',
    ],
    'euler': [
        'FINAL_TF_Euler128_periodicBC_lrm1',
        'FINAL_oml_Euler128_pBC_lr0m1',
    ],

}