from pathlib import Path

import numpy as np
import imageio
from PIL import ImageDraw, ImageFont
from PIL import Image

EPISODE_MIN = 0
EPISODE_MAX = 25_000
EPISODE_STEP = 500

VALID_ENV = "len300"

WANDB_RUNS = [
    "run-name-1",
    "run-name-2",
    "run-name-3",
    "run-name-4",
]


def main():
    font = ImageFont.truetype("/System/Library/Fonts/helvetica.ttc", 60)

    for run in WANDB_RUNS:
        Path(f"out/movies/{VALID_ENV}").mkdir(parents=True, exist_ok=True)
        with imageio.get_writer(f"out/movies/{VALID_ENV}/movie_{run}.mp4", fps=10) as writer:
            for episode in range(EPISODE_MIN, EPISODE_MAX+1, EPISODE_STEP):
                # read images
                matches = list(Path(f"out/ratemaps/{VALID_ENV}").glob(f"ratemap_*{run}_ep{episode}.png"))
                assert len(matches) == 1
                im_ratemap = Image.open(matches[0])

                matches = list(Path(f"out/ratemaps/{VALID_ENV}").glob(f"psychometric_noconfint_*{run}_ep{episode}.png"))
                # matches = [x for x in matches if ("noconfint" not in x.name)]
                assert len(matches) == 1
                im_psy = Image.open(matches[0])

                # paste onto canvas
                frame = Image.new("RGBA", (2816, 1504), (255, 255, 255))
                frame.paste(im_ratemap, (0, 0))
                frame.paste(im_psy, (1400, 150))

                ImageDraw.Draw(frame).text((2816-20, 1504-20), f"{episode}", (0, 0, 0), font=font, anchor="rd")

                writer.append_data(np.array(frame))  # noqa


if __name__ == "__main__":
    main()
