## Beyond Fair Recommendations: Objectifying User Retention in Tow-Sided Matching

This repository contains the code to replicate experiments conducted in the paper "[Beyond Fair Recommendations: Objectifying User Retention in Tow-Sided Matching](https:)" 



## Abstract
On two-sided matching platforms such as online dating and recruiting, recommendation algorithms often aim to maximize the total number of matches. However, this objective creates an imbalance, where some users receive far too many matches while many others receive very few and eventually abandon the platform. Retaining users is crucial for many platforms, such as those that depend heavily on subscriptions. The fairness objective is a typical alternative to mitigate imbalance by ensuring exposure for less-popular users. However, in reality, fairness is only a heuristic. Optimizing a fairness objective does not directly lead to user retention, since it provides recommendations without regard to the actual retention behaviors. Our stance is that objectifying fairness is not effective in , and the true objective is to optimize recommendations directly for user retention.
In this work, we go beyond heuristic objectives and formally define the new problem setting of maximizing user retention in two-sided matching platforms. To this end, we introduce a dynamic learning-to-rank (LTR) algorithm called \textbf{M}atching for \textbf{Ret}ention (\textbf{MRet}). Unlike conventional algorithms for two-sided matching, our approach learns user retention probabilities and adapts the recommendations dynamically. MRet generates recommendations by jointly considering retention probabilities from both perspectives: the user receiving recommendations and those who are being recommended. Empirical evaluations performed on both synthetic and real-world datasets, collected on a major online dating platform, show that our MRet algorithm retains many more users compared to conventional methods.

## Citation

```
@inproceedings{,
  author = {},
  title = {Beyond Fair Recommendations: Objectifying User Retention in Tow-Sided Matching},
  booktitle = {},
  pages = {},
  year = {},
}
```

## Dependencies
This repository supports Python 3.10.6 or newer.

- numpy==1.23.5
- pandas==1.5.2
- scikit-learn==1.1.3
- matplotlib==3.7.1
- torch==1.12.0


## Running the Code
The commands needed to reproduce the experiments are summarized below. Please move under the `synthetic` directly first and then run the notebooks.

### Synthetic Data

```bash
# How does MRet perform as the timestep $t$ increases?
synthetic/main/main_seed.ipynb
synthetic/main/show.ipynb

# How does MRet perform when user popularity varies?
synthetic/main/main_kappa.ipynb
synthetic/main/show.ipynb

# Why does Fairco underperform in user retention?
synthetic/main/main_seed.ipynb
synthetic/main/show.ipynb

# How does the proposed method perform when varying the number of users?
synthetic/main/main_n_xy.ipynb
synthetic/main/show.ipynb

# How does the hyperparameter of FairCo affect its performance?
synthetic/main/main_lambda.ipynb
synthetic/main/show.ipynb

# How accurate is MRet as an approximation to the Optimal method?
synthetic/main/main_seed_optimal.ipynb
synthetic/main/show.ipynb




```
