# URDF-Anything: Constructing Articulated Objects with 3D Multimodal Language Model

<div style="text-align: center;">
    <img src="assets/framework.png" width=100% >
</div>

## Install

### conda env

```
conda create -n urdf python=3.10 -y
conda activate urdf
pip install --upgrade pip  # enable PEP 660 support
pip install -e .
```

### Install additional packages for training cases

```
pip install -e ".[train]"
pip install flash-attn --no-build-isolation
```

### Install PointNet++

```
pip install "git+https://github.com/erikwijmans/Pointnet2_PyTorch.git#egg=pointnet2_ops&subdirectory=pointnet2_ops_lib"
```

### checkpoints

1. Down [ShapeLLM Model Zoo](https://github.com/qizekun/ShapeLLM/blob/main/docs/MODEL_ZOO.md) model weight.
2. Down [Uni3D](https://github.com/baaivision/Uni3D) model weight.

### Dataset

1. Please download [partnet-mobility dataset](https://sapien.ucsd.edu/downloads)
2. Use `./scripts/dataset/partnetObj2URDF.py` and `./scripts/dataset/modify_urdf.py` process partnet-mobility dataset

## Acknowledgement

This codebase is built upon [LLaVA](https://github.com/haotian-liu/LLaVA), [ReCon](https://github.com/qizekun/ReCon), [LISA](https://github.com/dvlab-research/LISA), [Uni3d](https://github.com/baaivision/Uni3D) and [ShapeLLM](https://github.com/qizekun/ShapeLLM.git).

## Related Works

- [LISA](https://github.com/dvlab-research/LISA)
- [ShapeLLM](https://github.com/qizekun/ShapeLLM.git)
- [Uni3d](https://github.com/baaivision/Uni3D)