import os
import numpy as np



def collate(resdir, trainval):
    accs = []
    for d, w, fns in os.walk(resdir):
        for fn in fns:
            if '12epoch_oritest' not in fn:
                continue
            if f'{not trainval}' in fn:
                continue
            if 'cutout' not in fn and 'standard' not in resdir:
                continue
            if int(fn.split('_')[-1].split('.')[0]) > 50:
                continue

            with open(os.path.join(d, fn), 'r') as f:
                for l in f:
                    acc = float(l.strip())
                    break
            accs.append(acc)
    print(len(accs))
    return np.mean(accs), np.std(accs), np.min(accs), np.max(accs)


#nas101_reanaswot_mean, nas101_reanaswot_std, nas101_reanaswot_min, nas101_reanaswot_max = collate('results/R_EA/nasbench101/cifar10/naswot/corrdistintegral0_025/', trainval=True)
#nas101_rea_mean, nas101_rea_std, nas101_rea_min, nas101_rea_max = collate('results/R_EA/nasbench101/cifar10/standard/', trainval=True)
nas201test_rea_mean, nas201test_rea_std, nas201test_rea_min, nas201test_rea_max = collate('results/R_EA/nasbench201/cifar10/standard/', trainval=False)
nas201test_reanaswot_mean, nas201test_reanaswot_std, nas201test_reanaswot_min, nas201test_reanaswot_max = collate('results/R_EA/nasbench201/cifar10/naswot/corrdistintegral0_025/', trainval=False)
nas201testcifar100_rea_mean, nas201testcifar100_rea_std, nas201testcifar100_rea_min, nas201testcifar100_rea_max = collate('results/R_EA/nasbench201/cifar100/standard/', trainval=False)
nas201testcifar100_reanaswot_mean, nas201testcifar100_reanaswot_std, nas201testcifar100_reanaswot_min, nas201testcifar100_reanaswot_max = collate('results/R_EA/nasbench201/cifar100/naswot/corrdistintegral0_025/', trainval=False)
nas201testimgnet_rea_mean, nas201testimgnet_rea_std, nas201testimgnet_rea_min, nas201testimgnet_rea_max = collate('results/R_EA/nasbench201/ImageNet16-120/standard/', trainval=False)
nas201testimgnet_reanaswot_mean, nas201testimgnet_reanaswot_std, nas201testimgnet_reanaswot_min, nas201testimgnet_reanaswot_max = collate('results/R_EA/nasbench201/ImageNet16-120/naswot/corrdistintegral0_025/', trainval=False)
#nas201_reanaswot_mean, nas201_reanaswot_std, nas201_reanaswot_min, nas201_reanaswot_max = collate('results/R_EA/nasbench201/cifar10/naswot/corrdistintegral0_025/', trainval=True)
#nas201_rea_mean, nas201_rea_std, nas201_rea_min, nas201_rea_max = collate('results/R_EA/nasbench201/cifar10/standard/', trainval=True)
#nas201cifar100_rea_mean, nas201cifar100_rea_std, nas201cifar100_rea_min, nas201cifar100_rea_max = collate('results/R_EA/nasbench201/cifar100/standard/', trainval=True)
#nas201imgnet_rea_mean, nas201imgnet_rea_std, nas201imgnet_rea_min, nas201imgnet_rea_max = collate('results/R_EA/nasbench201/ImageNet16-120/standard/', trainval=True)
#nas201cifar100_reanaswot_mean, nas201cifar100_reanaswot_std, nas201cifar100_reanaswot_min, nas201cifar100_reanaswot_max = collate('results/R_EA/nasbench201/cifar100/naswot/corrdistintegral0_025/', trainval=True)
#nas201cifar100_rea_mean, nas201cifar100_rea_std, nas201cifar100_rea_min, nas201cifar100_rea_max = collate('results/R_EA/nasbench201/cifar100/standard/')
#nas201imgnet_reanaswot_mean, nas201imgnet_reanaswot_std, nas201imgnet_reanaswot_min, nas201imgnet_reanaswot_max = collate('results/R_EA/nasbench201/ImageNet16-120/naswot/corrdistintegral0_025/', trainval=True)
#nas201imgnet_rea_mean, nas201imgnet_rea_std, nas201imgnet_rea_min, nas201imgnet_rea_max = collate('results/R_EA/nasbench201/ImageNet16-120/standard/')

#print(f'nas101_rea: {100.*nas101_rea_mean} +/- {100.*nas101_rea_std} [{100.*nas101_rea_min}, {100.*nas101_rea_max}]')
#print(f'nas101_reanaswot: {100.*nas101_reanaswot_mean} +/- {100.*nas101_reanaswot_std} [{100.*nas101_reanaswot_min}, {100.*nas101_reanaswot_max}]')
#print(f'nas201_rea: {nas201_rea_mean} +/- {nas201_rea_std} [{nas201_rea_min}, {nas201_rea_max}]')
#print(f'nas201_reanaswot: {nas201_reanaswot_mean} +/- {nas201_reanaswot_std} [{nas201_reanaswot_min}, {nas201_reanaswot_max}]')
print(f'nas201test_rea: {nas201test_rea_mean} +/- {nas201test_rea_std} [{nas201test_rea_min}, {nas201test_rea_max}]')
print(f'nas201test_reanaswot: {nas201test_reanaswot_mean} +/- {nas201test_reanaswot_std} [{nas201test_reanaswot_min}, {nas201test_reanaswot_max}]')
print('')
print(f'nas201testcifar100_rea: {nas201testcifar100_rea_mean} +/- {nas201testcifar100_rea_std} [{nas201testcifar100_rea_min}, {nas201testcifar100_rea_max}]')
print(f'nas201testcifar100_reanaswot: {nas201testcifar100_reanaswot_mean} +/- {nas201testcifar100_reanaswot_std} [{nas201testcifar100_reanaswot_min}, {nas201testcifar100_reanaswot_max}]')
print('')
print(f'nas201testimgnet_rea: {nas201testimgnet_rea_mean} +/- {nas201testimgnet_rea_std} [{nas201testimgnet_rea_min}, {nas201testimgnet_rea_max}]')
print(f'nas201testimgnet_reanaswot: {nas201testimgnet_reanaswot_mean} +/- {nas201testimgnet_reanaswot_std} [{nas201testimgnet_reanaswot_min}, {nas201testimgnet_reanaswot_max}]')
print('')
#print(f'nas201cifar100_rea: {nas201cifar100_rea_mean} +/- {nas201cifar100_rea_std} [{nas201cifar100_rea_min}, {nas201cifar100_rea_max}]')
#print(f'nas201cifar100_reanaswot: {nas201cifar100_reanaswot_mean} +/- {nas201cifar100_reanaswot_std} [{nas201cifar100_reanaswot_min}, {nas201cifar100_reanaswot_max}]')
#print(f'nas201cifar100_rea: {nas201cifar100_rea_mean} +/- {nas201cifar100_rea_std} [{nas201cifar100_rea_min}, {nas201cifar100_rea_max}]')
#print(f'nas201imgnet_rea: {nas201imgnet_rea_mean} +/- {nas201imgnet_rea_std} [{nas201imgnet_rea_min}, {nas201imgnet_rea_max}]')
#print(f'nas201imgnet_reanaswot: {nas201imgnet_reanaswot_mean} +/- {nas201imgnet_reanaswot_std} [{nas201imgnet_reanaswot_min}, {nas201imgnet_reanaswot_max}]')
#print(f'nas201imgnet_rea: {nas201imgnet_rea_mean} +/- {nas201imgnet_rea_std} [{nas201imgnet_rea_min}, {nas201imgnet_rea_max}]')

