import numpy as np

def evidenceapprox_eval_score(jacob, labels=None):
    jacob = jacob.reshape(jacob.size(0), -1).detach().cpu().numpy()
    corrs = np.corrcoef(jacob)
    v, _  = np.linalg.eig(corrs)
    k = 1e-5
    return -np.sum(np.log(v + k) + 1./(v + k))


def corrdistintegral_eval_score(upp):
    def fun(jacob, labels=None):
        xx = jacob.reshape(jacob.size(0), -1).detach().cpu().numpy()
        corrs = np.corrcoef(xx)
        return np.logical_and(corrs < upp, corrs > 0).sum()
    return fun

def random_score(jacob, label=None):
    return np.random.normal()


_scores = {
        'random': random_score,
        'evidenceapprox': evidenceapprox_eval_score,
        'corrdistintegral0_025': corrdistintegral_eval_score(0.25),
        'corrdistintegral0_05': corrdistintegral_eval_score(0.5)
        }

def get_score_func(score_name):
    return _scores[score_name]


