
import time
import numpy as np
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
plt.rcParams['agg.path.chunksize'] = 10000000
import random



def get_data(sample_num=100):
    simple_mean = [0, 0]
    simple_cov = [[10, 0], [0, 10]]
    x = np.random.multivariate_normal(simple_mean, simple_cov, sample_num)
    y = np.dot(x, np.array([1, 1]).T)
    ULN_mean = 0
    ULN_var = 0.5
    labelnoise = np.random.normal(ULN_mean, ULN_var, sample_num)
    ULN_y = y + labelnoise
    return x, y, ULN_y


def shuffle_data(x1, x2, y1, y2):
    seed = 0000
    random.seed(seed)
    random.shuffle(x1)
    random.seed(seed)
    random.shuffle(x2)
    random.seed(seed)
    random.shuffle(y1)
    random.seed(seed)
    random.shuffle(y2)


def f(x, y):
    return (x - 1) ** 2 + (y - 1) ** 2


# SGD
def msgd(x, y, y2, batch_size, step_size=0.01, max_iter_count=1000000):
    w = np.zeros((x.shape[1],))
    n = x.shape[0] // batch_size
    x1 = x[:, 0]
    x2 = x[:, 1]
    loss = 10
    iter_count = 0
    beta1 = [0]
    beta2 = [0]
    while abs(loss) > 0.000001*-1 and iter_count < max_iter_count:
        shuffle_data(x1, x2, y, y2)
        for j in range(0, n):
            start = j * batch_size
            end = (j + 1) * batch_size
            x1_sample = x1[start:end]
            x2_sample = x2[start:end]
            y_sample = y[start:end]
            w[0] -= step_size * \
                    np.sum((w[0] * x1_sample + w[1] * x2_sample - y_sample) * x1_sample) / batch_size
            w[1] -= step_size * \
                    np.sum((w[0] * x1_sample + w[1] * x2_sample - y_sample) * x2_sample) / batch_size
            loss = np.linalg.norm(w[0] * x1 + w[1] * x2 - y)
            beta1.append(w[0])
            beta2.append(w[1])
            iter_count += 1
            # print("iter_count:%d    the loss:%f" % (iter_count, loss))
    beta = np.concatenate(([beta1], [beta2]), axis=0).T
    return w, beta, iter_count


if __name__ == '__main__':
    greek_letterz = [chr(code) for code in range(945, 970)]
    print(greek_letterz)
    x, y, ULN_y = get_data()
    w, beta, iter_count = msgd(x, y, ULN_y, 5)
    w_ULN, beta_ULN, iter_count_ULN = msgd(x, ULN_y, y, 5)
    print(w, iter_count, w_ULN, iter_count_ULN)
    #step = 20
    #t1 = np.linspace(0, 2, step)
    #t2 = np.linspace(0, 2, step)
    #T1,T2 = np.meshgrid(t1, t2)
    #Z = f(T1, T2)
    #T = beta_ULN - beta
    plt.xlim(xmax=2, xmin=0)
    plt.ylim(ymax=2, ymin=0)
    plt.xlabel(greek_letterz[1]+"1")
    plt.ylabel(greek_letterz[1]+"2")
    params = {'legend.fontsize': 20,
              'legend.handlelength': 2}
    plt.rcParams.update(params)
    plt.plot(beta_ULN[:, 0], beta_ULN[:, 1], 'y-', label="with Label Noises")
    plt.plot(beta[:, 0], beta[:, 1], 'k-', label="without Label Noises")
    #plt.contourf(T1,T2,Z, alpha=0.8, cmap=plt.cm.hot)
    plt.grid()
    plt.legend()
    plt.show()
