
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('--prefix', default=None, type=str,
                    help='prefix of this run.')
parser.add_argument('--suffix', default=None, type=str,
                    help='suffix of this run.')
parser.add_argument('-n', '--network', default='resnet_v2_20', type=str,
                    help='network to use, to add.')
parser.add_argument('--dataset', default='cifar10', type=str,
                    help='dataset (cifar10 [default] or cifar100)')
parser.add_argument('--epochs', default=200, type=int,
                    help='number of total epochs to run')
parser.add_argument('--start_epoch', default=0, type=int,
                    help='manual epoch number (useful on restarts)')
parser.add_argument('-b', '--batch_size', default=64, type=int,
                    help='mini-batch size (default: 64)')
parser.add_argument('--lr', '--learning_rate', default=0.1, type=float,
                    help='initial learning rate')
parser.add_argument('--momentum', default=0.9, type=float, help='momentum')
parser.add_argument('--nesterov', default=0, type=int, help='nesterov momentum')
parser.add_argument('--weight_decay', '--wd', default=1e-4, type=float,
                    help='weight decay (default: 1e-4)')
parser.add_argument('--print_freq', '-p', default=100, type=int,
                    help='print frequency (default: 100)')
parser.add_argument('--init', '--initializer', default='he', type=str,
                    help='initialization of weights, xavier or he')
parser.add_argument('--augment', default=1, type=int,
                    help='whether to use standard augmentation (default: 1)')

# newly added for mutual information experiments.
parser.add_argument('--teacher_network', default='resnet_v2_56', type=str,
                    help='teacher network.')
parser.add_argument('--teacher_model',
                    default='./outdir/baseline-cifar100-resnet_v2_56-epo_200-b_64-lr_0.1-wd_0.0001-he-1-1/checkpoint.pth.tar',
                    type=str,
                    help='teacher model filename.')

# newly added for kd
parser.add_argument('--temperature', default=4.0, type=float,
                    help='temperature for KD.')
parser.add_argument('--kd_rate', default=0.0, type=float,
                    help='rate for kd')

# newly added for noises
parser.add_argument('--noise_force', default=0.1, type=float,
                    help='noise_force')
parser.add_argument('--noise_type', default='n', type=str,
                    help='n: normal, u: uniform.')
parser.add_argument('--seed', default=None, type=int,
                    help='random seed.')

# for test
parser.add_argument('--test_batch_size', default=1000, type=int,
                    help='mini-batch size (default: 1000)')
parser.add_argument('--num_worker', default=2, type=int,
                    help='number worker for datasets.')

parser.add_argument('--subset', default='train', type=str,
                    help='train or val')
parser.add_argument('--jac_type', default='logits', type=str,
                    help='logits or log (log-prob)')
parser.add_argument('--part_index', default=0, type=int,
                    help='part=10.')

# newly added for collecting results
parser.add_argument('-f', '--filter', default='', type=str,
                    help='must have this when collecting results.')
parser.add_argument('-t', '--threshold', default=0.0, type=float,
                    help='must better than this precision, max=1.0')

parser.add_argument('--outdir', default='outdir', type=str, help='log dir to save running logs.')

args = parser.parse_args()