from extensions.rl_lighthouse.lighthouse_experiments.base import (
    BaseLightHouseExperimentConfig,
)
from utils.experiment_utils import PipelineStage


class LightHouseAdvisorExperimentConfig(BaseLightHouseExperimentConfig):
    """PPO only."""

    @classmethod
    def tag(cls):
        return "LightHousePPO"

    @classmethod
    def training_pipeline(cls, **kwargs):
        training_steps = cls.TOTAL_TRAIN_STEPS
        ppo_info = cls.rl_loss_default("ppo", steps=training_steps)

        return cls._training_pipeline(
            named_losses={"ppo_loss": ppo_info["loss"],},
            pipeline_stages=[
                PipelineStage(
                    loss_names=["ppo_loss"],
                    early_stopping_criterion=cls.get_early_stopping_criterion(),
                    max_stage_steps=training_steps,
                ),
            ],
            num_mini_batch=ppo_info["num_mini_batch"],
            update_repeats=ppo_info["update_repeats"],
        )
