import torch

from extensions.rl_minigrid.minigrid_experiments.base import (
    MiniGridBaseExperimentConfig,
)
from utils.experiment_utils import PipelineStage, LinearDecay


class MiniGridDaggerExperimentConfig(MiniGridBaseExperimentConfig):
    """Training with DAgger."""

    GPU_ID = 0 if torch.cuda.is_available() else None
    USE_EXPERT = True

    @classmethod
    def extra_tag(cls):
        return "Dagger__tf_{}__lr_{}".format(cls.tf_ratio(), cls.lr())

    @classmethod
    def training_pipeline(cls, **kwargs):
        training_steps = cls.TOTAL_TRAIN_STEPS
        steps_tf_stage = int(training_steps * cls.tf_ratio())
        steps_bc_stage = training_steps - steps_tf_stage
        imitation_info = cls.rl_loss_default("imitation")
        return cls._training_pipeline(
            named_losses={"imitation_loss": imitation_info["loss"]},
            pipeline_stages=[
                PipelineStage(
                    loss_names=["imitation_loss"],
                    max_stage_steps=steps_tf_stage,
                    teacher_forcing=LinearDecay(
                        startp=1.0, endp=0.0, steps=steps_tf_stage,
                    ),
                ),
                PipelineStage(
                    loss_names=["imitation_loss"],
                    max_stage_steps=steps_bc_stage,
                    early_stopping_criterion=cls.task_info().get(
                        "early_stopping_criterion"
                    ),
                ),
            ],
            num_mini_batch=imitation_info["num_mini_batch"],
            update_repeats=imitation_info["update_repeats"],
        )
