import torch

from extensions.rl_poisoneddoors.poisoneddoors_experiments.base import (
    PoisonedDoorsBaseExperimentConfig,
)
from utils.experiment_utils import PipelineStage, LinearDecay


class PoisonedDoorsBCTeacherForcingExperimentConfig(PoisonedDoorsBaseExperimentConfig):
    """Training with behavior cloning."""

    GPU_ID = 0 if torch.cuda.is_available() else None
    USE_EXPERT = True

    @classmethod
    def extra_tag(cls):
        return "BC_TEACHER_FORCING__lr_{}".format(cls.lr())

    @classmethod
    def training_pipeline(cls, **kwargs):
        training_steps = cls.TOTAL_TRAIN_STEPS
        loss_info = cls.rl_loss_default("imitation")
        return cls._training_pipeline(
            num_mini_batch=loss_info["num_mini_batch"],
            update_repeats=loss_info["update_repeats"],
            named_losses={"imitation_loss": loss_info["loss"]},
            pipeline_stages=[
                PipelineStage(
                    loss_names=["imitation_loss"],
                    max_stage_steps=training_steps,
                    teacher_forcing=LinearDecay(
                        startp=1.0, endp=1.0, steps=training_steps,
                    ),
                ),
            ],
        )
