import glob
import os

import matplotlib.pyplot as plt

from extensions.rl_minigrid.minigrid_scripts.summarize_random_hp_search import (
    create_comparison_hp_plots_from_tsv,
)
from main import _get_args

plt.rc("font", **{"family": "serif", "serif": ["CMU"]})
plt.rc("text", usetex=True)
plt.rc("text.latex", preamble=r"\usepackage{amsmath}")

if __name__ == "__main__":
    args = _get_args()
    dir = "experiment_output/poisoneddoors_random_hp_runs"
    paths = []

    overwrite = True

    if args.env_name == "":
        paths = glob.glob(os.path.join(dir, "random_*.tsv"))
    else:
        paths = [
            "experiment_output/poisoneddoors_random_hp_runs/random_hp_search_poisoneddoors_runs_{}.tsv".format(
                args.env_name
            )
        ]

    for path in paths:
        print()
        print(os.path.basename(path))
        create_comparison_hp_plots_from_tsv(
            env_type="poisoneddoors",
            tsv_file_path=path,
            overwrite=overwrite,
            include_subset_max_plots=True,
            include_legend=False,
        )
