from extensions.rl_lighthouse.lighthouse_experiments.base import (
    BaseLightHouseExperimentConfig,
)
from utils.experiment_utils import PipelineStage, LinearDecay


class LightHouseBCTeacherForcingExperimentConfig(BaseLightHouseExperimentConfig):
    """Find goal in lighthouse env using imitation learning.

    Training with Imitation.
    """

    @classmethod
    def tag(cls):
        return "LightHouseBCTeacherForcing__lr_{}".format(cls.lr(),)

    @classmethod
    def training_pipeline(cls, **kwargs):
        training_steps = cls.TOTAL_TRAIN_STEPS
        loss_info = cls.rl_loss_default("imitation")

        return cls._training_pipeline(
            named_losses={"imitation_loss": loss_info["loss"]},
            pipeline_stages=[
                PipelineStage(
                    loss_names=["imitation_loss"],
                    teacher_forcing=LinearDecay(
                        startp=1.0, endp=1.0, steps=training_steps,
                    ),
                    max_stage_steps=training_steps,
                ),
            ],
            num_mini_batch=loss_info["num_mini_batch"],
            update_repeats=loss_info["update_repeats"],
        )
