import os
from pathlib import Path

MINIGRID_EXPERT_TRAJECTORIES_DIR = os.path.abspath(
    os.path.join(os.path.dirname(Path(__file__)), "minigrid_data", "minigrid_demos")
)
MINIGRID_ENV_NAMES_SUPPORTED = (
    "CrossingS25N10",
    "WallCrossingS25N10",
    "AskForHelpSimpleCrossing",
    "WallCrossingCorruptExpertS25N10",
    "AskForHelpLavaCrossingSmall",
    "AskForHelpSimpleCrossingOnce",
    "AskForHelpLavaCrossingOnce",
    "LavaCrossingCorruptExpertS15N7",
)


def demos_exist_for_env(env_name: str):
    return os.path.exists(
        os.path.join(
            MINIGRID_EXPERT_TRAJECTORIES_DIR, "MiniGrid-{}-v0.pkl".format(env_name)
        )
    )
