# Learning Spatio-Temporal Representation for Multivariate Time Series

📝 This repository is the official implementation of **Learning Spatio-Temporal Representation for Multivariate Time Series**. 

> Contributions
* We propose a novel contrastive representation learning method that encourages a *spatio-temporal consistency* to reflect the spatial structure of MTS along with its temporal dependency.
* To capture the inherent spatial information of MTS, our method converts an MTS instance into the graphs with diverse edge structures and enforces the representations from them to be consistent.
* To obtain the robust representation by alleviating the drawbacks of individual selection strategies, we simultaneously utilize several strategies to construct a positive pair.
* The proposed method generates universal representations that achieve superior performance for both classification and forecasting tasks compared to SOTAs.

> Illustration of overview of STCR

![overview](./figs/overview.png)

> Illustration of temporal and spatial embedding modules

![temporal_encoder](./figs/temporal_encoder.png)|![spatial_encoder](./figs/spatial_encoder.png)|
---|---|

## Requirements

💡 Our code requires *Python*, *PyTorch*, *Scikit-Learn*, *Scipy*, *NumPy*, and *Pandas*.

> Test with:
- python == 3.8.13
- PyTorch == 1.13.0
- scikit-learn == 0.24.2
- scipy == 1.6.3
- numpy == 1.22.2
- pandas == 1.4.4

📁 You can download the datasets and put the datasets into `datasets/` folder in the following way:
- [UEA & UCR Time Series Classification Repository](https://www.timeseriesclassification.com/) should be put into `datasets/UEA/`. For example, each data file is located by `datasets/UEA/<dataset_name>/<dataset_name>_*.arff`.
- [ETT datasets](https://github.com/zhouhaoyi/ETDataset) should be put into `datasets/ETTh1.csv`, `datasets/ETTh2.csv`, and `datasets/ETTm1.csv`.
- [Electricity dataset](https://archive.ics.uci.edu/ml/datasets/ElectricityLoadDiagrams20112014) should be preprocessed by `datasets/preprocess_electricity.py` and placed at `datasets/electricity.csv`.

## Training and Evaluation

💻 To train and evaluate STCR in the paper on a dataset, run the following command:

```train
python -u main.py <dataset> <run_name> --loader <loader> --connection <connection_parameter> --repr-dims <repr_dims> --batch-size <batch_size> --seed <seed> --eval
```
📚 The detailed descriptions about the arguments are as following:

| Parameter             | Description  |
| --------------------- |------------- |
| dataset               | The dataset name |
| run_name              | The folder name used to save model, output and evaluation metrics. This can be set to any word |
| loader                | The data loader used to load the experimental data. This can be set to UEA or forecast_csv |
| connection_parameter  | The parameter that decides number of connections (defaults to 0.5) |
| repr_dims             | The representation dimension (defaults to 320) |
| batch_size            | The batch size (defaults to 8) |
| seed                  | The random seed (defaults to 42) |

*For descriptions of more arguments used in this code, run ```python main.py -h```.*

* For example, you can obtain the classification results on 'PEMS-SF' dataset as:
```train
python -u main.py PEMS-SF UEA --loader UEA --connection 0.5 --repr-dims 320 --batch-size 8 --seed 42 --eval
```
## Results

📊 STCR achieved the classification performance as:

| Dataset | DTW | TNC | TS-TCC | TST | TS2Vec | STCR |
| ------- | --- | --- | ------ | --- | ------ | ---- |
|HandMovementDirection|0.231|0.351|0.324|0.243|0.243|0.338|0.351|
|PhonemeSpectra|0.151|0.222|0.207|0.252|0.085|0.233|0.186|
|JapaneseVowels|0.949|0.989|0.978|0.930|0.978|0.984|0.989|
|SpokenArabicDigits|0.963|0.905|0.934|0.970|0.923|0.988|0.955|
|NATOPS|0.883|0.917|0.911|0.822|0.850|0.928|0.944|
|FingerMovements|0.530|0.580|0.470|0.460|0.560|0.480|0.590|
|Heartbeat|0.717|0.741|0.746|0.751|0.746|0.683|0.746|
|MotorImagery|0.500|0.580|0.500|0.610|0.500|0.510|0.550|
|FaceDetection|0.529|0.513|0.536|0.544|0.534|0.501|0.557|
|InsectWingbeat|-|0.156|0.469|0.264|0.105|0.466|0.453|
|PEMS-SF|0.711|0.676|0.699|0.734|0.740|0.682|0.931|

*We use the results reported in [TS2Vec](https://arxiv.org/abs/2106.10466) for all baseline methods.*

📈 STCR achieved the forecasting performance as:

| Dataset | H | Informer || StemGNN  || TCN      || LogTrans || LSTnet   || TS2Vec   || STCR     ||
|----     |---|---- |---- |---- |---- |---- |---- |---- |---- |---- |---- |---- |---- |---- |---- | 
|         |   | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** | **MSE** | **MAE** |
|ETTh1    |24 |0.577|0.549|0.614|0.571|0.767|0.612|0.686|0.604|1.293|0.901|0.599|0.534|0.591|0.542|
|         |48 |0.685|0.625|0.748|0.618|0.713|0.617|0.766|0.757|1.456|0.960|0.629|0.555|0.626|0.565|
|         |168|0.931|0.752|0.663|0.608|0.995|0.738|1.002|0.846|1.997|1.214|0.755|0.636|0.762|0.644|
|         |336|1.128|0.873|0.927|0.730|1.175|0.800|1.362|0.952|2.655|1.369|0.907|0.717|0.910|0.721|
|         |720|1.251|0.896|  -  |  -  |1.453|1.311|1.397|1.291|2.143|1.380|1.048|0.790|0.997|0.770|
|ETTh2    |24 |0.720|0.665|1.292|0.883|1.365|0.888|0.828|0.750|2.742|1.457|0.398|0.461|0.375|0.467|
|         |48|1.457|1.001|1.099|0.847|1.395|0.960|1.806|1.034|3.567|1.687|0.580|0.573|0.605|0.597|
|         |168|3.489|1.515|2.282|1.228|3.166|1.407|4.070|1.681|3.242|2.513|1.901|1.065|1.587|1.002|
|         |336|2.723|1.340|3.086|1.351|3.256|1.481|3.875|1.763|2.544|2.591|2.304|1.215|1.956|1.130|
|         |720|3.467|1.473|  -  |  -  |3.690|1.588|3.913|1.552|4.625|3.709|2.650|1.373|2.092|1.159|
|ETTm1    |24 |0.323|0.369|0.620|0.570|0.324|0.374|0.419|0.412|1.968|1.170|0.443|0.436|0.430|0.432|
|         |48 |0.494|0.503|0.744|0.628|0.477|0.450|0.507|0.583|1.999|1.215|0.582|0.515|0.560|0.514|
|         |96 |0.678|0.614|0.709|0.624|0.636|0.602|0.768|0.792|2.762|1.542|0.622|0.549|0.601|0.545|
|         |288|1.056|0.786|0.843|0.683|1.270|1.351|1.462|1.320|1.257|2.076|0.709|0.609|0.665|0.589|
|         |672|1.192|0.926|  -  |  -  |1.381|1.467|1.669|1.461|1.917|2.941|0.786|0.655|0.779|0.654|
|Electricity|24 |0.312|0.387|0.439|0.388|0.305|0.384|0.297|0.374|0.356|0.419|0.287|0.374|0.331|0.406|
|           |48 |0.392|0.431|0.413|0.455|0.317|0.392|0.316|0.389|0.429|0.456|0.307|0.388|0.352|0.421|
|           |168|0.515|0.509|0.506|0.518|0.358|0.423|0.426|0.466|0.372|0.425|0.332|0.407|0.375|0.438|
|           |336|0.759|0.625|0.647|0.596|0.349|0.416|0.365|0.417|0.352|0.409|0.349|0.420|0.391|0.449|
|           |720|0.969|0.788|  -  |  -  |0.447|0.486|0.344|0.403|0.380|0.443|0.375|0.438|0.414|0.467|

*All $H \geq 672$ cases of StemGNN fail for the out-of-memory even when $B=1$.*

*We use the results reported in [TS2Vec](https://arxiv.org/abs/2106.10466) for all baseline methods.*


## Contributing
The code for STCR is implemented based on the official code of [TS2Vec](https://github.com/yuezhihan/ts2vec).