# DP-LoRA

Table of hyperparameter choices and associated FID values for DP-LoRA. The last 17 columns of the table are L2 distances between the weights of the fine-tuned model and the weights of the pretrained model. These distances are computed by concatenating all parameter deltas (in the layer) into a single vector and computing its L2 norm.

| Learning Rate | Rank | Epsilon | Batch Size | Epochs | FID   | Layer 1 | Layer 2 | Layer 3 | Layer 4 | Layer 5 | Layer 6 | Layer 7 | Layer 8 | Layer 9 | Layer 10 | Layer 11 | Layer 12 | Layer 13 | Layer 14 | Layer 15 | Layer 16 | All Params |
|---------------|------|---------|------------|--------|-------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----------|----------|----------|----------|----------|----------|----------|------------|
| 5.0e-07       | 1    | 1       | 128        | 70     | 63.5  | 1.18e-6 | 1.10e-6 | 1.32e-6 | 1.76e-6 | 1.52e-6 | 1.66e-6 | 1.39e-6 | 1.84e-6 | 1.95e-6 | 2.11e-6  | 1.56e-6  | 1.67e-6  | 1.73e-6  | 1.12e-6  | 1.19e-6  | 1.05e-6  | 6.17e-6    |
| 1.0e-06       | 1    | 1       | 128        | 70     | 34.3  | 1.34e-6 | 1.27e-6 | 1.79e-6 | 2.13e-6 | 2.26e-6 | 2.53e-6 | 2.03e-6 | 2.74e-6 | 2.68e-6 | 2.90e-6  | 2.03e-6  | 2.06e-6  | 2.18e-6  | 1.34e-6  | 1.36e-6  | 1.18e-6  | 8.25e-6    |
| 5.0e-06       | 1    | 1       | 128        | 70     | 28.8  | 1.91e-6 | 1.99e-6 | 3.35e-6 | 3.62e-6 | 5.59e-6 | 6.04e-6 | 5.54e-6 | 6.16e-6 | 5.76e-6 | 5.94e-6  | 3.34e-6  | 3.30e-6  | 3.54e-6  | 2.18e-6  | 2.05e-6  | 1.89e-6  | 1.68e-5    |
| 5.0e-07       | 2    | 1       | 128        | 70     | 192.4 | 4.63e-8 | 4.07e-8 | 4.77e-8 | 5.16e-8 | 5.88e-8 | 6.38e-8 | 5.95e-8 | 6.52e-8 | 6.49e-8 | 6.49e-8  | 4.75e-8  | 5.22e-8  | 5.92e-8  | 5.70e-8  | 5.11e-8  | 8.75e-8  | 2.33e-7    |
| 1.0e-06       | 2    | 1       | 128        | 70     | 43.1  | 1.19e-6 | 1.24e-6 | 1.82e-6 | 1.68e-6 | 2.04e-6 | 2.02e-6 | 1.85e-6 | 2.28e-6 | 2.23e-6 | 2.13e-6  | 1.73e-6  | 1.95e-6  | 2.06e-6  | 1.33e-6  | 1.27e-6  | 1.15e-6  | 7.16e-6    |
| 5.0e-06       | 2    | 1       | 128        | 70     | 27.0  | 1.91e-6 | 1.90e-6 | 3.19e-6 | 3.17e-6 | 5.08e-6 | 5.17e-6 | 5.04e-6 | 5.48e-6 | 5.20e-6 | 5.29e-6  | 3.15e-6  | 3.31e-6  | 3.37e-6  | 2.05e-6  | 2.01e-6  | 1.80e-6  | 1.53e-5    |
| 5.0e-07       | 4    | 1       | 128        | 70     | 100.5 | 8.01e-7 | 8.77e-7 | 1.09e-6 | 1.21e-6 | 1.11e-6 | 1.09e-6 | 1.14e-6 | 1.16e-6 | 1.31e-6 | 1.73e-6  | 8.82e-7  | 1.17e-6  | 1.32e-6  | 9.66e-7  | 9.71e-7  | 8.42e-7  | 4.51e-6    |
| 1.0e-06       | 4    | 1       | 128        | 70     | 47.4  | 1.03e-6 | 9.95e-7 | 1.53e-6 | 1.69e-6 | 1.79e-6 | 1.65e-6 | 1.74e-6 | 1.83e-6 | 2.00e-6 | 2.38e-6  | 1.29e-6  | 1.61e-6  | 1.78e-6  | 1.27e-6  | 1.21e-6  | 9.83e-7  | 6.38e-6    |
| 5.0e-06       | 4    | 1       | 128        | 70     | 25.8  | 1.77e-6 | 1.76e-6 | 2.79e-6 | 3.05e-6 | 4.56e-6 | 4.41e-6 | 4.61e-6 | 4.71e-6 | 4.63e-6 | 4.82e-6  | 2.82e-6  | 2.96e-6  | 3.16e-6  | 2.01e-6  | 1.91e-6  | 1.60e-6  | 1.37e-5    |
| 5.0e-07       | 8    | 1       | 128        | 70     | 132.0 | 7.14e-7 | 8.16e-7 | 7.99e-7 | 1.08e-6 | 9.34e-7 | 9.49e-7 | 9.57e-7 | 9.68e-7 | 1.06e-6 | 1.51e-6  | 7.24e-7  | 8.19e-7  | 1.03e-6  | 8.49e-7  | 8.52e-7  | 7.66e-7  | 3.78e-6    |
| 1.0e-06       | 8    | 1       | 128        | 70     | 80.8  | 9.09e-7 | 9.36e-7 | 1.21e-6 | 1.48e-6 | 1.42e-6 | 1.42e-6 | 1.43e-6 | 1.48e-6 | 1.62e-6 | 2.13e-6  | 1.12e-6  | 1.28e-6  | 1.45e-6  | 1.08e-6  | 1.06e-6  | 8.93e-7  | 5.37e-6    |
| 5.0e-06       | 8    | 1       | 128        | 70     | 26.9  | 1.59e-6 | 1.52e-6 | 2.49e-6 | 2.71e-6 | 3.97e-6 | 3.97e-6 | 4.01e-6 | 4.06e-6 | 4.11e-6 | 4.32e-6  | 2.55e-6  | 2.61e-6  | 2.84e-6  | 1.82e-6  | 1.74e-6  | 1.50e-6  | 1.22e-5    |
| 5.0e-07       | 64   | 1       | 128        | 70     | 188.2 | 7.53e-8 | 1.35e-7 | 1.12e-7 | 1.11e-7 | 1.44e-7 | 1.40e-7 | 1.46e-7 | 1.34e-7 | 1.49e-7 | 1.42e-7  | 1.09e-7  | 1.04e-7  | 1.13e-7  | 1.01e-7  | 1.62e-7  | 1.46e-7  | 5.14e-7    |
| 1.0e-06       | 64   | 1       | 128        | 70     | 162.1 | 6.41e-7 | 7.57e-7 | 7.16e-7 | 8.46e-7 | 8.75e-7 | 8.80e-7 | 8.91e-7 | 8.76e-7 | 9.13e-7 | 1.17e-6  | 7.09e-7  | 7.71e-7  | 9.44e-7  | 7.88e-7  | 7.73e-7  | 6.67e-7  | 3.34e-6    |
| 5.0e-06       | 64   | 1       | 128        | 70     | 41.7  | 1.18e-6 | 1.16e-6 | 1.83e-6 | 1.94e-6 | 2.74e-6 | 2.73e-6 | 2.80e-6 | 2.79e-6 | 2.83e-6 | 3.01e-6  | 1.82e-6  | 1.93e-6  | 2.06e-6  | 1.37e-6  | 1.30e-6  | 1.08e-6  | 8.57e-6    |
| 5.0e-07       | 1    | 5       | 128        | 70     | 34.7  | 1.27e-6 | 1.23e-6 | 1.68e-6 | 2.02e-6 | 1.82e-6 | 2.12e-6 | 1.47e-6 | 2.43e-6 | 2.41e-6 | 2.63e-6  | 1.97e-6  | 2.01e-6  | 2.07e-6  | 1.26e-6  | 1.34e-6  | 1.15e-6  | 7.46e-6    |
| 1.0e-06       | 1    | 5       | 128        | 70     | 28.6  | 1.46e-6 | 1.41e-6 | 2.09e-6 | 2.41e-6 | 2.59e-6 | 3.03e-6 | 2.20e-6 | 3.29e-6 | 3.11e-6 | 3.42e-6  | 2.31e-6  | 2.39e-6  | 2.54e-6  | 1.43e-6  | 1.47e-6  | 1.30e-6  | 9.52e-6    |
| 5.0e-06       | 1    | 5       | 128        | 70     | 26.5  | 2.01e-6 | 2.07e-6 | 3.44e-6 | 3.72e-6 | 5.65e-6 | 6.36e-6 | 5.59e-6 | 6.38e-6 | 6.00e-6 | 6.07e-6  | 3.49e-6  | 3.56e-6  | 3.69e-6  | 2.21e-6  | 2.17e-6  | 1.95e-6  | 1.74e-5    |
| 5.0e-07       | 2    | 5       | 128        | 70     | 41.1  | 1.14e-6 | 1.13e-6 | 1.69e-6 | 1.58e-6 | 1.66e-6 | 1.55e-6 | 1.31e-6 | 1.85e-6 | 1.74e-6 | 1.90e-6  | 1.64e-6  | 1.88e-6  | 1.98e-6  | 1.32e-6  | 1.27e-6  | 1.10e-6  | 6.29e-6    |
| 1.0e-06       | 2    | 5       | 128        | 70     | 29.5  | 1.37e-6 | 1.35e-6 | 2.09e-6 | 1.95e-6 | 2.49e-6 | 2.37e-6 | 1.93e-6 | 2.80e-6 | 2.51e-6 | 2.63e-6  | 2.09e-6  | 2.29e-6  | 2.34e-6  | 1.53e-6  | 1.47e-6  | 1.19e-6  | 8.34e-6    |
| 5.0e-06       | 2    | 5       | 128        | 70     | 23.7  | 2.00e-6 | 2.06e-6 | 3.31e-6 | 3.36e-6 | 5.21e-6 | 5.33e-6 | 5.28e-6 | 5.72e-6 | 5.31e-6 | 5.56e-6  | 3.33e-6  | 3.58e-6  | 3.58e-6  | 2.22e-6  | 2.20e-6  | 1.87e-6  | 1.60e-5    |
| 5.0e-07       | 4    | 5       | 128        | 70     | 48.1  | 9.25e-7 | 9.42e-7 | 1.42e-6 | 1.58e-6 | 1.38e-6 | 1.17e-6 | 1.28e-6 | 1.43e-6 | 1.66e-6 | 2.24e-6  | 1.17e-6  | 1.56e-6  | 1.75e-6  | 1.19e-6  | 1.13e-6  | 9.28e-7  | 5.60e-6    |
| 1.0e-06       | 4    | 5       | 128        | 70     | 30.1  | 1.16e-6 | 1.06e-6 | 1.77e-6 | 1.97e-6 | 2.20e-6 | 1.75e-6 | 1.96e-6 | 2.23e-6 | 2.34e-6 | 2.84e-6  | 1.63e-6  | 1.93e-6  | 2.13e-6  | 1.46e-6  | 1.35e-6  | 1.07e-6  | 7.47e-6    |
| 5.0e-06       | 4    | 5       | 128        | 70     | 25.1  | 1.44e-6 | 1.39e-6 | 2.27e-6 | 2.47e-6 | 3.58e-6 | 3.41e-6 | 3.61e-6 | 3.76e-6 | 3.65e-6 | 3.89e-6  | 2.36e-6  | 2.48e-6  | 2.71e-6  | 1.69e-6  | 1.61e-6  | 1.30e-6  | 1.10e-5    |
| 5.0e-07       | 8    | 5       | 128        | 70     | 80.5  | 8.37e-7 | 9.22e-7 | 1.10e-6 | 1.40e-6 | 9.61e-7 | 9.51e-7 | 9.74e-7 | 1.07e-6 | 1.31e-6 | 2.01e-6  | 9.79e-7  | 1.20e-6  | 1.38e-6  | 1.05e-6  | 1.04e-6  | 8.45e-7  | 4.65e-6    |
| 1.0e-06       | 8    | 5       | 128        | 70     | 38.8  | 1.01e-6 | 1.03e-6 | 1.48e-6 | 1.81e-6 | 1.55e-6 | 1.46e-6 | 1.54e-6 | 1.73e-6 | 1.95e-6 | 2.58e-6  | 1.44e-6  | 1.65e-6  | 1.80e-6  | 1.32e-6  | 1.21e-6  | 9.67e-7  | 6.33e-6    |
| 5.0e-06       | 8    | 5       | 128        | 70     | 23.8  | 1.71e-6 | 1.64e-6 | 2.63e-6 | 2.89e-6 | 4.11e-6 | 4.07e-6 | 4.09e-6 | 4.27e-6 | 4.26e-6 | 4.59e-6  | 2.76e-6  | 2.89e-6  | 3.12e-6  | 2.02e-6  | 1.82e-6  | 1.52e-6  | 1.28e-5    |
| 5.0e-07       | 64   | 5       | 128        | 70     | 162.4 | 6.04e-7 | 7.23e-7 | 5.53e-7 | 7.46e-7 | 5.94e-7 | 5.76e-7 | 6.14e-7 | 5.86e-7 | 6.53e-7 | 1.03e-6  | 5.87e-7  | 6.78e-7  | 8.81e-7  | 7.34e-7  | 7.78e-7  | 6.10e-7  | 2.78e-6    |
| 1.0e-06       | 64   | 5       | 128        | 70     | 107.8 | 7.59e-7 | 8.53e-7 | 8.94e-7 | 1.13e-6 | 8.90e-7 | 8.87e-7 | 9.12e-7 | 9.51e-7 | 1.05e-6 | 1.59e-6  | 9.31e-7  | 1.08e-6  | 1.27e-6  | 9.58e-7  | 9.23e-7  | 7.25e-7  | 4.03e-6    |
| 5.0e-06       | 64   | 5       | 128        | 70     | 28.5  | 1.27e-6 | 1.21e-6 | 1.95e-6 | 2.10e-6 | 2.86e-6 | 2.78e-6 | 2.86e-6 | 2.96e-6 | 2.94e-6 | 3.24e-6  | 2.01e-6  | 2.15e-6  | 2.26e-6  | 1.58e-6  | 1.44e-6  | 1.12e-6  | 9.10e-6    |
| 5.0e-07       | 1    | 10      | 128        | 70     | 32.5  | 1.34e-6 | 1.25e-6 | 1.78e-6 | 2.08e-6 | 1.93e-6 | 2.29e-6 | 1.52e-6 | 2.61e-6 | 2.55e-6 | 2.79e-6  | 2.05e-6  | 2.11e-6  | 2.15e-6  | 1.26e-6  | 1.34e-6  | 1.18e-6  | 7.83e-6    |
| 1.0e-06       | 1    | 10      | 128        | 70     | 27.9  | 1.47e-6 | 1.43e-6 | 2.13e-6 | 2.45e-6 | 2.69e-6 | 3.17e-6 | 2.27e-6 | 3.47e-6 | 3.26e-6 | 3.59e-6  | 2.40e-6  | 2.45e-6  | 2.61e-6  | 1.42e-6  | 1.53e-6  | 1.30e-6  | 9.87e-6    |
| 5.0e-06       | 1    | 10      | 128        | 70     | 26.2  | 2.07e-6 | 2.10e-6 | 3.49e-6 | 3.80e-6 | 5.71e-6 | 6.42e-6 | 5.62e-6 | 6.46e-6 | 6.03e-6 | 6.13e-6  | 3.52e-6  | 3.61e-6  | 3.73e-6  | 2.27e-6  | 2.19e-6  | 1.97e-6  | 1.76e-5    |
| 5.0e-07       | 2    | 10      | 128        | 70     | 35.4  | 1.20e-6 | 1.19e-6 | 1.74e-6 | 1.63e-6 | 1.82e-6 | 1.64e-6 | 1.34e-6 | 1.99e-6 | 1.84e-6 | 2.04e-6  | 1.74e-6  | 1.98e-6  | 2.06e-6  | 1.37e-6  | 1.28e-6  | 1.06e-6  | 6.62e-6    |
| 1.0e-06       | 2    | 10      | 128        | 70     | 28.5  | 1.34e-6 | 1.40e-6 | 2.16e-6 | 2.05e-6 | 2.63e-6 | 2.47e-6 | 1.99e-6 | 2.94e-6 | 2.65e-6 | 2.78e-6  | 2.18e-6  | 2.41e-6  | 2.43e-6  | 1.58e-6  | 1.55e-6  | 1.26e-6  | 8.72e-6    |
| 5.0e-06       | 2    | 10      | 128        | 70     | 23.0  | 2.07e-6 | 2.10e-6 | 3.35e-6 | 3.46e-6 | 5.26e-6 | 5.41e-6 | 5.34e-6 | 5.76e-6 | 5.36e-6 | 5.63e-6  | 3.36e-6  | 3.65e-6  | 3.65e-6  | 2.27e-6  | 2.24e-6  | 1.83e-6  | 1.62e-5    |
| 5.0e-07       | 4    | 10      | 128        | 70     | 40.3  | 9.99e-7 | 9.63e-7 | 1.51e-6 | 1.66e-6 | 1.51e-6 | 1.21e-6 | 1.33e-6 | 1.53e-6 | 1.77e-6 | 2.35e-6  | 1.25e-6  | 1.62e-6  | 1.84e-6  | 1.28e-6  | 1.16e-6  | 9.60e-7  | 5.91e-6    |
| 1.0e-06       | 4    | 10      | 128        | 70     | 28.7  | 1.20e-6 | 1.07e-6 | 1.84e-6 | 2.03e-6 | 2.33e-6 | 1.80e-6 | 2.04e-6 | 2.34e-6 | 2.41e-6 | 2.98e-6  | 1.78e-6  | 2.04e-6  | 2.23e-6  | 1.54e-6  | 1.38e-6  | 1.09e-6  | 7.80e-6    |
| 5.0e-06       | 4    | 10      | 128        | 70     | 22.7  | 1.91e-6 | 1.78e-6 | 2.95e-6 | 3.20e-6 | 4.75e-6 | 4.55e-6 | 4.80e-6 | 4.98e-6 | 4.84e-6 | 5.14e-6  | 3.13e-6  | 3.30e-6  | 3.54e-6  | 2.23e-6  | 2.00e-6  | 1.70e-6  | 1.46e-5    |
| 5.0e-07       | 8    | 10      | 128        | 70     | 68.2  | 8.72e-7 | 9.19e-7 | 1.20e-6 | 1.48e-6 | 9.88e-7 | 9.71e-7 | 1.00e-6 | 1.11e-6 | 1.41e-6 | 2.10e-6  | 1.06e-6  | 1.30e-6  | 1.47e-6  | 1.08e-6  | 1.07e-6  | 9.08e-7  | 4.89e-6    |
| 1.0e-06       | 8    | 10      | 128        | 70     | 34.3  | 1.09e-6 | 1.06e-6 | 1.56e-6 | 1.87e-6 | 1.63e-6 | 1.49e-6 | 1.57e-6 | 1.82e-6 | 2.03e-6 | 2.71e-6  | 1.54e-6  | 1.74e-6  | 1.91e-6  | 1.33e-6  | 1.27e-6  | 1.01e-6  | 6.62e-6    |
| 5.0e-06       | 8    | 10      | 128        | 70     | 23.2  | 1.74e-6 | 1.63e-6 | 2.66e-6 | 2.93e-6 | 4.14e-6 | 4.11e-6 | 4.14e-6 | 4.33e-6 | 4.31e-6 | 4.62e-6  | 2.85e-6  | 2.96e-6  | 3.22e-6  | 2.02e-6  | 1.91e-6  | 1.57e-6  | 1.30e-5    |
| 5.0e-07       | 64   | 10      | 128        | 70     | 152.1 | 6.38e-7 | 7.74e-7 | 5.83e-7 | 8.27e-7 | 5.71e-7 | 5.75e-7 | 5.77e-7 | 5.90e-7 | 6.90e-7 | 1.16e-6  | 6.33e-7  | 7.54e-7  | 9.58e-7  | 7.77e-7  | 8.11e-7  | 6.37e-7  | 2.96e-6    |
| 1.0e-06       | 64   | 10      | 128        | 70     | 123.8 | 6.20e-7 | 7.25e-7 | 6.82e-7 | 8.98e-7 | 6.79e-7 | 6.66e-7 | 6.81e-7 | 6.94e-7 | 7.76e-7 | 1.24e-6  | 7.17e-7  | 8.33e-7  | 1.00e-6  | 7.75e-7  | 7.76e-7  | 6.03e-7  | 3.16e-6    |
| 5.0e-06       | 64   | 10      | 128        | 70     | 27.3  | 1.30e-6 | 1.25e-6 | 2.02e-6 | 2.15e-6 | 2.90e-6 | 2.81e-6 | 2.90e-6 | 3.03e-6 | 2.97e-6 | 3.30e-6  | 2.07e-6  | 2.20e-6  | 2.33e-6  | 1.59e-6  | 1.44e-6  | 1.14e-6  | 9.28e-6    |
| 5.0e-07       | 1    | 1       | 512        | 70     | 31.2  | 1.42e-6 | 1.38e-6 | 1.94e-6 | 2.40e-6 | 2.56e-6 | 2.79e-6 | 2.29e-6 | 3.07e-6 | 3.24e-6 | 2.99e-6  | 2.26e-6  | 2.34e-6  | 2.40e-6  | 1.39e-6  | 1.42e-6  | 1.24e-6  | 9.15e-6    |
| 1.0e-06       | 1    | 1       | 512        | 70     | 43.5  | 7.55e-7 | 7.72e-7 | 1.06e-6 | 1.31e-6 | 1.40e-6 | 1.45e-6 | 1.36e-6 | 1.61e-6 | 1.75e-6 | 1.46e-6  | 1.26e-6  | 1.26e-6  | 1.31e-6  | 7.80e-7  | 7.94e-7  | 6.99e-7  | 4.93e-6    |
| 5.0e-06       | 1    | 1       | 512        | 70     | 26.3  | 2.74e-6 | 2.94e-6 | 5.30e-6 | 5.45e-6 | 1.06e-5 | 1.10e-5 | 1.08e-5 | 1.09e-5 | 1.08e-5 | 1.05e-5  | 4.82e-6  | 4.76e-6  | 4.84e-6  | 2.53e-6  | 2.68e-6  | 2.88e-6  | 2.93e-5    |
| 5.0e-07       | 2    | 1       | 512        | 70     | 30.6  | 1.30e-6 | 1.30e-6 | 1.97e-6 | 1.99e-6 | 2.59e-6 | 2.20e-6 | 2.12e-6 | 2.60e-6 | 2.30e-6 | 2.72e-6  | 1.98e-6  | 2.14e-6  | 2.30e-6  | 1.44e-6  | 1.46e-6  | 1.16e-6  | 8.12e-6    |
| 1.0e-06       | 2    | 1       | 512        | 70     | 26.2  | 1.54e-6 | 1.53e-6 | 2.46e-6 | 2.51e-6 | 3.66e-6 | 3.35e-6 | 3.23e-6 | 3.71e-6 | 3.36e-6 | 3.79e-6  | 2.55e-6  | 2.69e-6  | 2.74e-6  | 1.76e-6  | 1.71e-6  | 1.35e-6  | 1.10e-5    |
| 5.0e-06       | 2    | 1       | 512        | 70     | 24.9  | 2.80e-6 | 2.97e-6 | 5.17e-6 | 5.17e-6 | 1.01e-5 | 1.01e-5 | 1.02e-5 | 1.01e-5 | 1.01e-5 | 9.93e-6  | 5.07e-6  | 4.94e-6  | 5.11e-6  | 2.86e-6  | 2.76e-6  | 2.73e-6  | 2.79e-5    |
| 5.0e-07       | 4    | 1       | 512        | 70     | 33.3  | 1.17e-6 | 1.09e-6 | 1.69e-6 | 1.85e-6 | 2.10e-6 | 1.85e-6 | 1.96e-6 | 2.15e-6 | 2.29e-6 | 2.74e-6  | 1.54e-6  | 1.86e-6  | 2.08e-6  | 1.38e-6  | 1.30e-6  | 1.01e-6  | 7.25e-6    |
| 1.0e-06       | 4    | 1       | 512        | 70     | 26.7  | 1.41e-6 | 1.31e-6 | 2.16e-6 | 2.35e-6 | 3.14e-6 | 2.87e-6 | 3.02e-6 | 3.21e-6 | 3.25e-6 | 3.60e-6  | 2.13e-6  | 2.34e-6  | 2.58e-6  | 1.68e-6  | 1.55e-6  | 1.26e-6  | 9.92e-6    |
| 5.0e-06       | 4    | 1       | 512        | 70     | 23.9  | 2.63e-6 | 2.67e-6 | 4.64e-6 | 4.76e-6 | 8.61e-6 | 8.74e-6 | 8.80e-6 | 8.91e-6 | 8.76e-6 | 8.87e-6  | 4.65e-6  | 4.62e-6  | 4.90e-6  | 2.80e-6  | 2.70e-6  | 2.51e-6  | 2.47e-5    |
| 5.0e-07       | 8    | 1       | 512        | 70     | 52.8  | 9.59e-7 | 1.04e-6 | 1.42e-6 | 1.68e-6 | 1.58e-6 | 1.57e-6 | 1.63e-6 | 1.74e-6 | 1.89e-6 | 2.44e-6  | 1.35e-6  | 1.54e-6  | 1.66e-6  | 1.23e-6  | 1.17e-6  | 9.65e-7  | 6.15e-6    |
| 1.0e-06       | 8    | 1       | 512        | 70     | 30.2  | 1.25e-6 | 1.23e-6 | 1.90e-6 | 2.17e-6 | 2.58e-6 | 2.48e-6 | 2.60e-6 | 2.73e-6 | 2.82e-6 | 3.22e-6  | 1.89e-6  | 2.03e-6  | 2.23e-6  | 1.54e-6  | 1.41e-6  | 1.13e-6  | 8.66e-6    |
| 5.0e-06       | 8    | 1       | 512        | 70     | 23.1  | 2.42e-6 | 2.36e-6 | 4.15e-6 | 4.35e-6 | 7.37e-6 | 7.38e-6 | 7.50e-6 | 7.57e-6 | 7.61e-6 | 7.61e-6  | 4.19e-6  | 4.22e-6  | 4.47e-6  | 2.63e-6  | 2.49e-6  | 2.28e-6  | 2.14e-5    |
| 5.0e-07       | 64   | 1       | 512        | 70     | 130.7 | 7.27e-7 | 8.20e-7 | 8.03e-7 | 1.04e-6 | 9.66e-7 | 9.93e-7 | 1.01e-6 | 1.00e-6 | 1.05e-6 | 1.45e-6  | 8.72e-7  | 9.56e-7  | 1.16e-6  | 8.98e-7  | 8.53e-7  | 7.07e-7  | 3.89e-6    |
| 1.0e-06       | 64   | 1       | 512        | 70     | 70.6  | 9.18e-7 | 9.80e-7 | 1.27e-6 | 1.48e-6 | 1.64e-6 | 1.65e-6 | 1.67e-6 | 1.72e-6 | 1.79e-6 | 2.14e-6  | 1.33e-6  | 1.46e-6  | 1.59e-6  | 1.10e-6  | 1.09e-6  | 8.50e-7  | 5.84e-6    |
| 5.0e-07       | 1    | 5       | 512        | 70     | 26.6  | 1.54e-6 | 1.58e-6 | 2.42e-6 | 2.65e-6 | 3.19e-6 | 3.71e-6 | 2.70e-6 | 3.98e-6 | 3.94e-6 | 3.81e-6  | 2.64e-6  | 2.69e-6  | 2.85e-6  | 1.61e-6  | 1.60e-6  | 1.39e-6  | 1.11e-5    |
| 1.0e-06       | 1    | 5       | 512        | 70     | 25.4  | 1.73e-6 | 1.93e-6 | 2.88e-6 | 3.18e-6 | 4.24e-6 | 4.71e-6 | 3.92e-6 | 4.88e-6 | 4.85e-6 | 4.17e-6  | 3.06e-6  | 3.13e-6  | 3.34e-6  | 1.93e-6  | 1.88e-6  | 1.56e-6  | 1.36e-5    |
| 5.0e-06       | 1    | 5       | 512        | 70     | 24.3  | 2.89e-6 | 3.14e-6 | 5.51e-6 | 5.63e-6 | 1.10e-5 | 1.14e-5 | 1.11e-5 | 1.12e-5 | 1.10e-5 | 1.08e-5  | 4.97e-6  | 5.06e-6  | 4.89e-6  | 2.83e-6  | 2.82e-6  | 3.03e-6  | 3.03e-5    |
| 5.0e-07       | 2    | 5       | 512        | 70     | 24.8  | 1.48e-6 | 1.50e-6 | 2.34e-6 | 2.36e-6 | 3.30e-6 | 2.93e-6 | 2.52e-6 | 3.45e-6 | 3.03e-6 | 3.50e-6  | 2.55e-6  | 2.73e-6  | 2.72e-6  | 1.72e-6  | 1.69e-6  | 1.28e-6  | 1.02e-5    |
| 1.0e-06       | 2    | 5       | 512        | 70     | 23.1  | 1.73e-6 | 1.80e-6 | 2.74e-6 | 2.82e-6 | 4.11e-6 | 3.92e-6 | 3.66e-6 | 4.34e-6 | 4.02e-6 | 4.37e-6  | 2.94e-6  | 3.19e-6  | 3.19e-6  | 1.99e-6  | 1.91e-6  | 1.52e-6  | 1.27e-5    |
| 5.0e-06       | 2    | 5       | 512        | 70     | 22.1  | 2.91e-6 | 3.07e-6 | 5.06e-6 | 5.10e-6 | 9.96e-6 | 1.01e-5 | 1.01e-5 | 1.02e-5 | 1.01e-5 | 9.89e-6  | 5.11e-6  | 5.06e-6  | 5.32e-6  | 3.05e-6  | 2.94e-6  | 2.84e-6  | 2.80e-5    |
| 5.0e-07       | 4    | 5       | 512        | 70     | 25.4  | 1.30e-6 | 1.11e-6 | 1.98e-6 | 2.18e-6 | 2.64e-6 | 2.07e-6 | 2.36e-6 | 2.74e-6 | 2.72e-6 | 3.31e-6  | 1.99e-6  | 2.24e-6  | 2.48e-6  | 1.67e-6  | 1.45e-6  | 1.09e-6  | 8.69e-6    |
| 1.0e-06       | 4    | 5       | 512        | 70     | 22.9  | 1.63e-6 | 1.44e-6 | 2.44e-6 | 2.66e-6 | 3.57e-6 | 3.23e-6 | 3.49e-6 | 3.85e-6 | 3.72e-6 | 4.17e-6  | 2.67e-6  | 2.87e-6  | 3.09e-6  | 2.06e-6  | 1.78e-6  | 1.37e-6  | 1.15e-5    |
| 5.0e-06       | 4    | 5       | 512        | 70     | 20.8  | 2.73e-6 | 2.84e-6 | 4.71e-6 | 4.85e-6 | 8.71e-6 | 8.78e-6 | 8.92e-6 | 9.09e-6 | 8.95e-6 | 9.01e-6  | 4.77e-6  | 4.85e-6  | 5.10e-6  | 3.03e-6  | 2.79e-6  | 2.57e-6  | 2.52e-5    |
| 5.0e-07       | 8    | 5       | 512        | 70     | 27.5  | 1.22e-6 | 1.11e-6 | 1.81e-6 | 2.15e-6 | 2.03e-6 | 1.71e-6 | 1.94e-6 | 2.38e-6 | 2.52e-6 | 3.14e-6  | 1.89e-6  | 2.09e-6  | 2.23e-6  | 1.56e-6  | 1.40e-6  | 1.06e-6  | 7.86e-6    |
| 1.0e-06       | 8    | 5       | 512        | 70     | 111.4 | 2.45e-7 | 2.77e-7 | 2.99e-7 | 3.95e-7 | 3.08e-7 | 3.10e-7 | 3.16e-7 | 3.26e-7 | 3.72e-7 | 5.48e-7  | 2.64e-7  | 3.37e-7  | 3.97e-7  | 3.04e-7  | 2.80e-7  | 2.46e-7  | 1.34e-6    |
| 5.0e-06       | 8    | 5       | 512        | 70     | 20.0  | 2.47e-6 | 2.50e-6 | 4.25e-6 | 4.44e-6 | 7.45e-6 | 7.58e-6 | 7.59e-6 | 7.75e-6 | 7.75e-6 | 7.77e-6  | 4.44e-6  | 4.56e-6  | 4.80e-6  | 2.85e-6  | 2.69e-6  | 2.33e-6  | 2.20e-5    |
| 5.0e-07       | 1    | 10      | 512        | 70     | 31.2  | 7.09e-7 | 6.57e-7 | 1.07e-6 | 1.16e-6 | 1.16e-6 | 1.33e-6 | 8.73e-7 | 1.61e-6 | 1.61e-6 | 1.50e-6  | 1.23e-6  | 1.25e-6  | 1.21e-6  | 7.09e-7  | 7.40e-7  | 6.01e-7  | 4.55e-6    |
| 1.0e-06       | 1    | 10      | 512        | 70     | 25.4  | 1.77e-6 | 2.03e-6 | 2.92e-6 | 3.22e-6 | 4.38e-6 | 4.80e-6 | 4.08e-6 | 5.02e-6 | 4.95e-6 | 4.45e-6  | 3.11e-6  | 3.18e-6  | 3.41e-6  | 1.98e-6  | 1.91e-6  | 1.60e-6  | 1.40e-5    |
| 5.0e-06       | 1    | 10      | 512        | 70     | 23.6  | 2.96e-6 | 3.22e-6 | 5.58e-6 | 5.60e-6 | 1.10e-5 | 1.13e-5 | 1.11e-5 | 1.12e-5 | 1.09e-5 | 1.08e-5  | 5.10e-6  | 5.08e-6  | 4.87e-6  | 2.92e-6  | 2.87e-6  | 3.06e-6  | 3.02e-5    |
| 5.0e-07       | 2    | 10      | 512        | 70     | 24.1  | 1.51e-6 | 1.55e-6 | 2.42e-6 | 2.46e-6 | 3.46e-6 | 3.14e-6 | 2.69e-6 | 3.64e-6 | 3.26e-6 | 3.67e-6  | 2.66e-6  | 2.86e-6  | 2.88e-6  | 1.76e-6  | 1.73e-6  | 1.27e-6  | 1.07e-5    |
| 1.0e-06       | 2    | 10      | 512        | 70     | 22.5  | 1.77e-6 | 1.87e-6 | 2.81e-6 | 2.91e-6 | 4.24e-6 | 4.10e-6 | 3.80e-6 | 4.50e-6 | 4.20e-6 | 4.51e-6  | 3.03e-6  | 3.33e-6  | 3.34e-6  | 2.02e-6  | 1.98e-6  | 1.53e-6  | 1.31e-5    |
| 5.0e-06       | 2    | 10      | 512        | 70     | 20.9  | 2.92e-6 | 3.21e-6 | 5.15e-6 | 5.21e-6 | 1.02e-5 | 1.02e-5 | 1.02e-5 | 1.04e-5 | 1.03e-5 | 1.00e-5  | 5.17e-6  | 5.16e-6  | 5.32e-6  | 3.01e-6  | 2.95e-6  | 2.91e-6  | 2.84e-5    |
| 5.0e-07       | 4    | 10      | 512        | 70     | 33.2  | 6.04e-7 | 5.66e-7 | 9.71e-7 | 1.07e-6 | 1.03e-6 | 7.58e-7 | 8.63e-7 | 1.06e-6 | 1.17e-6 | 1.53e-6  | 8.71e-7  | 1.06e-6  | 1.20e-6  | 8.08e-7  | 6.87e-7  | 5.46e-7  | 3.84e-6    |
| 1.0e-06       | 4    | 10      | 512        | 70     | 22.3  | 1.65e-6 | 1.54e-6 | 2.52e-6 | 2.70e-6 | 3.70e-6 | 3.34e-6 | 3.64e-6 | 4.00e-6 | 3.83e-6 | 4.29e-6  | 2.79e-6  | 2.98e-6  | 3.24e-6  | 2.14e-6  | 1.84e-6  | 1.43e-6  | 1.20e-5    |
| 5.0e-06       | 4    | 10      | 512        | 70     | 20.4  | 2.73e-6 | 2.84e-6 | 4.71e-6 | 4.91e-6 | 8.74e-6 | 8.81e-6 | 8.93e-6 | 9.14e-6 | 8.97e-6 | 9.02e-6  | 4.85e-6  | 4.94e-6  | 5.18e-6  | 3.06e-6  | 2.81e-6  | 2.59e-6  | 2.53e-5    |
| 5.0e-07       | 8    | 10      | 512        | 70     | 25.8  | 1.27e-6 | 1.17e-6 | 1.90e-6 | 2.23e-6 | 2.19e-6 | 1.83e-6 | 2.09e-6 | 2.59e-6 | 2.69e-6 | 3.37e-6  | 2.02e-6  | 2.22e-6  | 2.39e-6  | 1.57e-6  | 1.47e-6  | 1.11e-6  | 8.37e-6    |
| 1.0e-06       | 8    | 10      | 512        | 70     | 22.9  | 1.54e-6 | 1.39e-6 | 2.30e-6 | 2.59e-6 | 3.05e-6 | 2.83e-6 | 2.99e-6 | 3.48e-6 | 3.47e-6 | 3.97e-6  | 2.49e-6  | 2.69e-6  | 2.87e-6  | 1.88e-6  | 1.72e-6  | 1.31e-6  | 1.06e-5    |
| 5.0e-06       | 8    | 10      | 512        | 70     | 19.5  | 2.54e-6 | 2.50e-6 | 4.28e-6 | 4.47e-6 | 7.46e-6 | 7.61e-6 | 7.63e-6 | 7.80e-6 | 7.78e-6 | 7.84e-6  | 4.56e-6  | 4.66e-6  | 4.84e-6  | 2.93e-6  | 2.74e-6  | 2.33e-6  | 2.22e-5    |
| 5.0e-07       | 64   | 10      | 512        | 70     | 39.3  | 1.00e-6 | 9.99e-7 | 1.37e-6 | 1.64e-6 | 1.26e-6 | 1.09e-6 | 1.18e-6 | 1.50e-6 | 1.62e-6 | 2.32e-6  | 1.41e-6  | 1.63e-6  | 1.77e-6  | 1.25e-6  | 1.14e-6  | 8.87e-7  | 5.70e-6    |
| 1.0e-06       | 64   | 10      | 512        | 70     | 27.5  | 1.18e-6 | 1.12e-6 | 1.72e-6 | 1.99e-6 | 2.11e-6 | 1.82e-6 | 1.94e-6 | 2.33e-6 | 2.29e-6 | 2.92e-6  | 1.83e-6  | 2.04e-6  | 2.19e-6  | 1.51e-6  | 1.36e-6  | 1.03e-6  | 7.60e-6    |
| 5.0e-07       | 1    | 1       | 2048       | 70     | 27.1  | 1.59e-6 | 1.72e-6 | 2.65e-6 | 2.79e-6 | 3.79e-6 | 4.45e-6 | 3.88e-6 | 4.27e-6 | 4.40e-6 | 4.38e-6  | 2.74e-6  | 2.83e-6  | 2.95e-6  | 1.72e-6  | 1.73e-6  | 1.45e-6  | 1.26e-5    |
| 1.0e-06       | 1    | 1       | 2048       | 70     | 26.3  | 2.03e-6 | 2.16e-6 | 3.48e-6 | 3.62e-6 | 5.89e-6 | 6.46e-6 | 6.01e-6 | 6.11e-6 | 6.17e-6 | 6.01e-6  | 3.47e-6  | 3.59e-6  | 3.71e-6  | 2.16e-6  | 2.16e-6  | 1.89e-6  | 1.76e-5    |
| 5.0e-06       | 1    | 1       | 2048       | 70     | 29.7  | 3.62e-6 | 4.21e-6 | 8.27e-6 | 7.81e-6 | 2.24e-5 | 2.28e-5 | 2.40e-5 | 2.26e-5 | 2.24e-5 | 2.06e-5  | 6.62e-6  | 5.82e-6  | 6.28e-6  | 3.03e-6  | 3.30e-6  | 3.90e-6  | 5.79e-5    |
| 5.0e-07       | 2    | 1       | 2048       | 70     | 26.0  | 1.56e-6 | 1.65e-6 | 2.55e-6 | 2.66e-6 | 3.79e-6 | 3.53e-6 | 3.42e-6 | 3.81e-6 | 3.66e-6 | 3.92e-6  | 2.62e-6  | 2.81e-6  | 2.86e-6  | 1.79e-6  | 1.74e-6  | 1.38e-6  | 1.15e-5    |
| 1.0e-06       | 2    | 1       | 2048       | 70     | 24.5  | 1.93e-6 | 2.08e-6 | 3.27e-6 | 3.42e-6 | 5.44e-6 | 5.28e-6 | 5.26e-6 | 5.55e-6 | 5.43e-6 | 5.56e-6  | 3.31e-6  | 3.55e-6  | 3.67e-6  | 2.18e-6  | 2.15e-6  | 1.78e-6  | 1.60e-5    |
| 5.0e-06       | 2    | 1       | 2048       | 70     | 30.3  | 4.11e-6 | 4.17e-6 | 8.52e-6 | 8.01e-6 | 2.00e-5 | 1.99e-5 | 2.08e-5 | 2.04e-5 | 2.02e-5 | 1.92e-5  | 7.25e-6  | 6.71e-6  | 6.94e-6  | 3.38e-6  | 3.53e-6  | 4.30e-6  | 5.27e-5    |
| 5.0e-07       | 4    | 1       | 2048       | 70     | 25.9  | 1.46e-6 | 1.34e-6 | 2.27e-6 | 2.44e-6 | 3.35e-6 | 3.05e-6 | 3.12e-6 | 3.38e-6 | 3.36e-6 | 3.75e-6  | 2.21e-6  | 2.45e-6  | 2.68e-6  | 1.76e-6  | 1.60e-6  | 1.26e-6  | 1.04e-5    |
| 1.0e-06       | 4    | 1       | 2048       | 70     | 24.2  | 1.84e-6 | 1.79e-6 | 2.99e-6 | 3.17e-6 | 4.79e-6 | 4.71e-6 | 4.78e-6 | 4.94e-6 | 4.89e-6 | 5.11e-6  | 3.06e-6  | 3.23e-6  | 3.41e-6  | 2.17e-6  | 1.99e-6  | 1.62e-6  | 1.45e-5    |
| 5.0e-06       | 4    | 1       | 2048       | 70     | 25.6  | 4.17e-6 | 4.28e-6 | 8.34e-6 | 7.93e-6 | 1.78e-5 | 1.81e-5 | 1.85e-5 | 1.79e-5 | 1.80e-5 | 1.74e-5  | 7.44e-6  | 6.90e-6  | 7.33e-6  | 3.66e-6  | 3.75e-6  | 4.34e-6  | 4.80e-5    |
| 5.0e-07       | 8    | 1       | 2048       | 70     | 28.8  | 1.30e-6 | 1.23e-6 | 1.98e-6 | 2.23e-6 | 2.77e-6 | 2.63e-6 | 2.74e-6 | 2.82e-6 | 2.98e-6 | 3.39e-6  | 2.06e-6  | 2.16e-6  | 2.30e-6  | 1.65e-6  | 1.52e-6  | 1.20e-6  | 9.11e-6    |
| 1.0e-06       | 8    | 1       | 2048       | 70     | 25.0  | 1.70e-6 | 1.56e-6 | 2.67e-6 | 2.89e-6 | 4.18e-6 | 4.08e-6 | 4.22e-6 | 4.25e-6 | 4.32e-6 | 4.60e-6  | 2.79e-6  | 2.88e-6  | 3.07e-6  | 1.98e-6  | 1.85e-6  | 1.54e-6  | 1.29e-5    |
| 5.0e-06       | 8    | 1       | 2048       | 70     | 26.1  | 4.08e-6 | 4.06e-6 | 7.78e-6 | 7.52e-6 | 1.52e-5 | 1.57e-5 | 1.56e-5 | 1.56e-5 | 1.56e-5 | 1.52e-5  | 7.23e-6  | 6.88e-6  | 7.21e-6  | 3.70e-6  | 3.73e-6  | 4.06e-6  | 4.22e-5    |
| 5.0e-07       | 64   | 1       | 2048       | 70     | 60.0  | 9.67e-7 | 9.90e-7 | 1.39e-6 | 1.55e-6 | 1.72e-6 | 1.73e-6 | 1.75e-6 | 1.79e-6 | 1.89e-6 | 2.19e-6  | 1.44e-6  | 1.53e-6  | 1.65e-6  | 1.20e-6  | 1.12e-6  | 8.83e-7  | 6.12e-6    |
| 1.0e-06       | 64   | 1       | 2048       | 70     | 68.5  | 7.65e-7 | 7.53e-7 | 1.09e-6 | 1.19e-6 | 1.47e-6 | 1.49e-6 | 1.51e-6 | 1.52e-6 | 1.57e-6 | 1.71e-6  | 1.11e-6  | 1.16e-6  | 1.26e-6  | 8.64e-7  | 8.04e-7  | 6.83e-7  | 4.92e-6    |
| 5.0e-06       | 64   | 1       | 2048       | 70     | 22.3  | 2.87e-6 | 2.81e-6 | 4.98e-6 | 4.94e-6 | 8.99e-6 | 9.11e-6 | 9.25e-6 | 9.22e-6 | 9.15e-6 | 9.24e-6  | 5.03e-6  | 5.07e-6  | 5.21e-6  | 3.04e-6  | 2.95e-6  | 2.76e-6  | 2.59e-5    |
| 5.0e-07       | 1    | 5       | 2048       | 70     | 24.0  | 1.83e-6 | 1.93e-6 | 3.01e-6 | 3.19e-6 | 4.54e-6 | 5.21e-6 | 4.62e-6 | 5.10e-6 | 5.05e-6 | 5.06e-6  | 3.24e-6  | 3.27e-6  | 3.42e-6  | 2.12e-6  | 1.87e-6  | 1.56e-6  | 1.47e-5    |
| 1.0e-06       | 1    | 5       | 2048       | 70     | 23.3  | 2.19e-6 | 2.48e-6 | 3.72e-6 | 4.03e-6 | 6.59e-6 | 7.02e-6 | 6.35e-6 | 6.58e-6 | 6.60e-6 | 6.48e-6  | 4.03e-6  | 3.96e-6  | 4.07e-6  | 2.52e-6  | 2.12e-6  | 2.07e-6  | 1.91e-5    |
| 5.0e-06       | 1    | 5       | 2048       | 70     | 23.7  | 3.48e-6 | 3.78e-6 | 7.36e-6 | 6.86e-6 | 1.98e-5 | 1.96e-5 | 2.09e-5 | 1.99e-5 | 1.93e-5 | 1.78e-5  | 5.82e-6  | 5.10e-6  | 5.55e-6  | 3.07e-6  | 3.13e-6  | 3.54e-6  | 5.04e-5    |
| 5.0e-07       | 2    | 5       | 2048       | 70     | 26.2  | 8.42e-7 | 8.78e-7 | 1.39e-6 | 1.42e-6 | 2.06e-6 | 1.92e-6 | 1.52e-6 | 2.17e-6 | 1.89e-6 | 2.24e-6  | 1.55e-6  | 1.65e-6  | 1.63e-6  | 9.73e-7  | 9.27e-7  | 6.73e-7  | 6.24e-6    |
| 1.0e-06       | 2    | 5       | 2048       | 70     | 21.5  | 2.09e-6 | 2.37e-6 | 3.55e-6 | 3.74e-6 | 5.98e-6 | 5.85e-6 | 5.55e-6 | 6.31e-6 | 5.90e-6 | 6.28e-6  | 3.79e-6  | 4.08e-6  | 4.16e-6  | 2.42e-6  | 2.44e-6  | 1.92e-6  | 1.78e-5    |
| 5.0e-06       | 2    | 5       | 2048       | 70     | 24.1  | 3.73e-6 | 3.88e-6 | 7.49e-6 | 6.97e-6 | 1.83e-5 | 1.89e-5 | 1.97e-5 | 1.90e-5 | 1.88e-5 | 1.76e-5  | 6.51e-6  | 6.21e-6  | 6.48e-6  | 3.35e-6  | 3.36e-6  | 3.58e-6  | 4.89e-5    |
| 5.0e-07       | 4    | 5       | 2048       | 70     | 21.7  | 1.72e-6 | 1.55e-6 | 2.60e-6 | 2.80e-6 | 3.85e-6 | 3.72e-6 | 3.78e-6 | 4.23e-6 | 4.01e-6 | 4.47e-6  | 2.98e-6  | 3.16e-6  | 3.30e-6  | 2.19e-6  | 1.85e-6  | 1.37e-6  | 1.25e-5    |
| 1.0e-06       | 4    | 5       | 2048       | 70     | 20.9  | 2.11e-6 | 1.98e-6 | 3.22e-6 | 3.48e-6 | 5.13e-6 | 5.19e-6 | 5.18e-6 | 5.51e-6 | 5.33e-6 | 5.63e-6  | 3.63e-6  | 3.83e-6  | 4.03e-6  | 2.48e-6  | 2.19e-6  | 1.73e-6  | 1.61e-5    |
| 5.0e-06       | 4    | 5       | 2048       | 70     | 20.5  | 3.86e-6 | 3.96e-6 | 7.63e-6 | 7.16e-6 | 1.70e-5 | 1.74e-5 | 1.78e-5 | 1.74e-5 | 1.71e-5 | 1.65e-5  | 6.85e-6  | 6.37e-6  | 6.92e-6  | 3.62e-6  | 3.42e-6  | 3.67e-6  | 4.58e-5    |
| 5.0e-07       | 8    | 5       | 2048       | 70     | 22.5  | 1.55e-6 | 1.43e-6 | 2.41e-6 | 2.62e-6 | 3.32e-6 | 3.06e-6 | 3.31e-6 | 3.64e-6 | 3.64e-6 | 4.11e-6  | 2.70e-6  | 2.87e-6  | 3.02e-6  | 1.95e-6  | 1.71e-6  | 1.29e-6  | 1.12e-5    |
| 1.0e-06       | 8    | 5       | 2048       | 70     | 20.9  | 1.91e-6 | 1.77e-6 | 3.03e-6 | 3.16e-6 | 4.53e-6 | 4.42e-6 | 4.61e-6 | 4.85e-6 | 4.78e-6 | 5.06e-6  | 3.37e-6  | 3.55e-6  | 3.72e-6  | 2.34e-6  | 2.09e-6  | 1.60e-6  | 1.45e-5    |
| 5.0e-06       | 8    | 5       | 2048       | 70     | 20.5  | 3.84e-6 | 3.81e-6 | 7.37e-6 | 7.01e-6 | 1.49e-5 | 1.55e-5 | 1.54e-5 | 1.53e-5 | 1.53e-5 | 1.47e-5  | 6.85e-6  | 6.58e-6  | 6.88e-6  | 3.70e-6  | 3.53e-6  | 3.65e-6  | 4.12e-5    |
| 5.0e-07       | 64   | 5       | 2048       | 70     | 26.4  | 1.25e-6 | 1.12e-6 | 1.87e-6 | 2.06e-6 | 2.32e-6 | 2.01e-6 | 2.08e-6 | 2.48e-6 | 2.49e-6 | 3.06e-6  | 1.94e-6  | 2.13e-6  | 2.27e-6  | 1.62e-6  | 1.38e-6  | 1.04e-6  | 8.07e-6    |
| 1.0e-06       | 64   | 5       | 2048       | 70     | 22.6  | 1.51e-6 | 1.33e-6 | 2.23e-6 | 2.42e-6 | 3.22e-6 | 3.09e-6 | 3.12e-6 | 3.44e-6 | 3.40e-6 | 3.79e-6  | 2.40e-6  | 2.61e-6  | 2.73e-6  | 1.84e-6  | 1.62e-6  | 1.26e-6  | 1.05e-5    |
| 5.0e-06       | 64   | 5       | 2048       | 70     | 18.2  | 2.90e-6 | 2.86e-6 | 5.02e-6 | 5.02e-6 | 9.09e-6 | 9.17e-6 | 9.27e-6 | 9.31e-6 | 9.27e-6 | 9.32e-6  | 5.22e-6  | 5.22e-6  | 5.41e-6  | 3.16e-6  | 3.01e-6  | 2.73e-6  | 2.63e-5    |
| 5.0e-07       | 1    | 10      | 2048       | 70     | 23.8  | 1.85e-6 | 2.05e-6 | 3.10e-6 | 3.31e-6 | 4.92e-6 | 5.45e-6 | 4.88e-6 | 5.26e-6 | 5.26e-6 | 5.26e-6  | 3.38e-6  | 3.43e-6  | 3.54e-6  | 2.14e-6  | 1.83e-6  | 1.62e-6  | 1.53e-5    |
| 1.0e-06       | 1    | 10      | 2048       | 70     | 23.7  | 2.18e-6 | 2.55e-6 | 3.93e-6 | 4.15e-6 | 7.02e-6 | 7.16e-6 | 6.44e-6 | 6.71e-6 | 6.74e-6 | 6.65e-6  | 4.15e-6  | 4.06e-6  | 4.15e-6  | 2.58e-6  | 2.19e-6  | 2.13e-6  | 1.97e-5    |
| 5.0e-06       | 1    | 10      | 2048       | 70     | 24.6  | 3.50e-6 | 3.58e-6 | 7.16e-6 | 6.61e-6 | 1.86e-5 | 1.81e-5 | 1.96e-5 | 1.93e-5 | 1.81e-5 | 1.68e-5  | 5.92e-6  | 5.09e-6  | 5.32e-6  | 3.04e-6  | 3.09e-6  | 3.56e-6  | 4.77e-5    |
| 5.0e-07       | 2    | 10      | 2048       | 70     | 22.9  | 1.21e-6 | 1.29e-6 | 1.95e-6 | 2.06e-6 | 3.06e-6 | 3.01e-6 | 2.59e-6 | 3.31e-6 | 2.98e-6 | 3.34e-6  | 2.22e-6  | 2.36e-6  | 2.36e-6  | 1.39e-6  | 1.36e-6  | 9.91e-7  | 9.39e-6    |
| 1.0e-06       | 2    | 10      | 2048       | 70     | 21.7  | 2.18e-6 | 2.44e-6 | 3.66e-6 | 3.82e-6 | 6.24e-6 | 6.05e-6 | 5.73e-6 | 6.50e-6 | 6.16e-6 | 6.47e-6  | 3.96e-6  | 4.23e-6  | 4.27e-6  | 2.57e-6  | 2.48e-6  | 1.99e-6  | 1.84e-5    |
| 5.0e-06       | 2    | 10      | 2048       | 70     | 23.0  | 3.76e-6 | 3.82e-6 | 7.32e-6 | 6.80e-6 | 1.78e-5 | 1.84e-5 | 1.91e-5 | 1.84e-5 | 1.82e-5 | 1.70e-5  | 6.37e-6  | 5.97e-6  | 6.33e-6  | 3.35e-6  | 3.31e-6  | 3.54e-6  | 4.76e-5    |
| 5.0e-07       | 4    | 10      | 2048       | 70     | 21.3  | 1.79e-6 | 1.66e-6 | 2.68e-6 | 2.92e-6 | 4.08e-6 | 4.01e-6 | 4.04e-6 | 4.47e-6 | 4.24e-6 | 4.64e-6  | 3.21e-6  | 3.36e-6  | 3.49e-6  | 2.23e-6  | 1.93e-6  | 1.48e-6  | 1.32e-5    |
| 1.0e-06       | 4    | 10      | 2048       | 70     | 20.0  | 2.14e-6 | 2.09e-6 | 3.36e-6 | 3.62e-6 | 5.34e-6 | 5.38e-6 | 5.32e-6 | 5.71e-6 | 5.47e-6 | 5.81e-6  | 3.82e-6  | 3.99e-6  | 4.20e-6  | 2.57e-6  | 2.26e-6  | 1.80e-6  | 1.67e-5    |
| 5.0e-06       | 4    | 10      | 2048       | 70     | 19.3  | 3.71e-6 | 3.82e-6 | 7.45e-6 | 6.99e-6 | 1.68e-5 | 1.71e-5 | 1.75e-5 | 1.71e-5 | 1.68e-5 | 1.62e-5  | 6.77e-6  | 6.29e-6  | 6.77e-6  | 3.63e-6  | 3.40e-6  | 3.54e-6  | 4.50e-5    |
| 5.0e-07       | 8    | 10      | 2048       | 70     | 21.4  | 1.65e-6 | 1.50e-6 | 2.54e-6 | 2.72e-6 | 3.48e-6 | 3.33e-6 | 3.56e-6 | 3.97e-6 | 3.86e-6 | 4.29e-6  | 2.91e-6  | 3.08e-6  | 3.26e-6  | 2.04e-6  | 1.85e-6  | 1.33e-6  | 1.19e-5    |
| 1.0e-06       | 8    | 10      | 2048       | 70     | 19.6  | 1.98e-6 | 1.84e-6 | 3.12e-6 | 3.19e-6 | 4.64e-6 | 4.63e-6 | 4.73e-6 | 5.08e-6 | 4.91e-6 | 5.19e-6  | 3.61e-6  | 3.76e-6  | 3.96e-6  | 2.40e-6  | 2.19e-6  | 1.65e-6  | 1.50e-5    |
| 5.0e-06       | 8    | 10      | 2048       | 70     | 19.4  | 3.73e-6 | 3.68e-6 | 7.26e-6 | 6.89e-6 | 1.48e-5 | 1.54e-5 | 1.53e-5 | 1.52e-5 | 1.52e-5 | 1.46e-5  | 6.85e-6  | 6.52e-6  | 6.85e-6  | 3.68e-6  | 3.48e-6  | 3.43e-6  | 4.08e-5    |
| 5.0e-07       | 64   | 10      | 2048       | 70     | 24.3  | 1.31e-6 | 1.15e-6 | 1.97e-6 | 2.16e-6 | 2.56e-6 | 2.20e-6 | 2.25e-6 | 2.78e-6 | 2.73e-6 | 3.31e-6  | 2.12e-6  | 2.30e-6  | 2.47e-6  | 1.74e-6  | 1.45e-6  | 1.11e-6  | 8.74e-6    |
| 1.0e-06       | 64   | 10      | 2048       | 70     | 21.0  | 1.53e-6 | 1.40e-6 | 2.34e-6 | 2.51e-6 | 3.33e-6 | 3.24e-6 | 3.29e-6 | 3.67e-6 | 3.54e-6 | 3.97e-6  | 2.60e-6  | 2.81e-6  | 2.93e-6  | 1.99e-6  | 1.68e-6  | 1.32e-6  | 1.10e-5    |
| 5.0e-06       | 64   | 10      | 2048       | 70     | 17.7  | 2.95e-6 | 2.83e-6 | 5.04e-6 | 5.03e-6 | 9.07e-6 | 9.17e-6 | 9.29e-6 | 9.34e-6 | 9.28e-6 | 9.34e-6  | 5.31e-6  | 5.35e-6  | 5.51e-6  | 3.24e-6  | 3.06e-6  | 2.74e-6  | 2.64e-5    |
| 5.0e-07       | 1    | 1       | 8192       | 70     | 27.3  | 2.01e-6 | 2.24e-6 | 3.61e-6 | 3.60e-6 | 6.32e-6 | 6.44e-6 | 5.98e-6 | 6.48e-6 | 6.35e-6 | 6.12e-6  | 3.67e-6  | 3.69e-6  | 3.67e-6  | 2.19e-6  | 2.09e-6  | 1.79e-6  | 1.80e-5    |
| 1.0e-06       | 1    | 1       | 8192       | 70     | 26.9  | 2.64e-6 | 2.93e-6 | 5.29e-6 | 5.00e-6 | 1.09e-5 | 1.07e-5 | 1.08e-5 | 1.07e-5 | 1.08e-5 | 1.02e-5  | 5.02e-6  | 4.75e-6  | 4.64e-6  | 2.66e-6  | 2.61e-6  | 2.57e-6  | 2.90e-5    |
| 5.0e-06       | 1    | 1       | 8192       | 70     | 36.4  | 4.86e-7 | 5.39e-7 | 1.19e-6 | 1.19e-6 | 2.73e-6 | 2.72e-6 | 2.89e-6 | 2.72e-6 | 2.74e-6 | 2.60e-6  | 1.21e-6  | 1.07e-6  | 1.06e-6  | 4.85e-7  | 5.06e-7  | 4.14e-7  | 7.25e-6    |
| 5.0e-07       | 2    | 1       | 8192       | 70     | 24.6  | 1.88e-6 | 1.99e-6 | 3.38e-6 | 3.36e-6 | 5.48e-6 | 5.59e-6 | 5.31e-6 | 5.87e-6 | 5.66e-6 | 5.66e-6  | 3.46e-6  | 3.64e-6  | 3.63e-6  | 2.19e-6  | 2.12e-6  | 1.61e-6  | 1.64e-5    |
| 1.0e-06       | 2    | 1       | 8192       | 70     | 24.3  | 2.55e-6 | 2.79e-6 | 5.00e-6 | 4.86e-6 | 9.21e-6 | 9.63e-6 | 9.67e-6 | 9.85e-6 | 9.55e-6 | 9.35e-6  | 4.80e-6  | 4.75e-6  | 4.86e-6  | 2.76e-6  | 2.77e-6  | 2.28e-6  | 2.64e-5    |
| 5.0e-06       | 2    | 1       | 8192       | 70     | 44.4  | 4.68e-6 | 5.06e-6 | 1.39e-5 | 1.12e-5 | 4.23e-5 | 5.12e-5 | 5.47e-5 | 5.13e-5 | 4.94e-5 | 4.36e-5  | 1.05e-5  | 8.63e-6  | 8.90e-6  | 3.68e-6  | 3.87e-6  | 4.33e-6  | 1.23e-4    |
| 5.0e-07       | 4    | 1       | 8192       | 70     | 23.5  | 1.85e-6 | 1.78e-6 | 3.19e-6 | 3.23e-6 | 4.98e-6 | 4.88e-6 | 4.97e-6 | 5.26e-6 | 5.06e-6 | 5.34e-6  | 3.24e-6  | 3.26e-6  | 3.58e-6  | 2.23e-6  | 1.97e-6  | 1.65e-6  | 1.51e-5    |
| 1.0e-06       | 4    | 1       | 8192       | 70     | 21.5  | 2.52e-6 | 2.55e-6 | 4.72e-6 | 4.72e-6 | 8.43e-6 | 8.51e-6 | 8.55e-6 | 8.77e-6 | 8.60e-6 | 8.67e-6  | 4.63e-6  | 4.58e-6  | 4.86e-6  | 2.78e-6  | 2.63e-6  | 2.34e-6  | 2.42e-5    |
| 5.0e-06       | 4    | 1       | 8192       | 70     | 43.6  | 5.72e-6 | 5.97e-6 | 1.49e-5 | 1.29e-5 | 4.08e-5 | 4.46e-5 | 4.50e-5 | 4.38e-5 | 4.31e-5 | 3.99e-5  | 1.26e-5  | 1.01e-5  | 1.06e-5  | 4.44e-6  | 4.65e-6  | 5.33e-6  | 1.09e-4    |
| 5.0e-07       | 8    | 1       | 8192       | 70     | 24.7  | 1.66e-6 | 1.56e-6 | 2.66e-6 | 2.86e-6 | 4.15e-6 | 4.09e-6 | 4.23e-6 | 4.34e-6 | 4.37e-6 | 4.54e-6  | 2.77e-6  | 2.96e-6  | 3.05e-6  | 1.93e-6  | 1.77e-6  | 1.45e-6  | 1.29e-5    |
| 1.0e-06       | 8    | 1       | 8192       | 70     | 23.1  | 2.24e-6 | 2.19e-6 | 3.92e-6 | 4.07e-6 | 6.87e-6 | 6.97e-6 | 7.08e-6 | 7.09e-6 | 7.15e-6 | 7.14e-6  | 4.01e-6  | 4.15e-6  | 4.28e-6  | 2.47e-6  | 2.33e-6  | 2.11e-6  | 2.02e-5    |
| 5.0e-06       | 8    | 1       | 8192       | 70     | 43.7  | 5.89e-6 | 5.89e-6 | 1.35e-5 | 1.31e-5 | 3.30e-5 | 3.51e-5 | 3.54e-5 | 3.44e-5 | 3.47e-5 | 3.24e-5  | 1.25e-5  | 1.07e-5  | 1.10e-5  | 4.80e-6  | 4.95e-6  | 5.78e-6  | 8.89e-5    |
| 5.0e-07       | 64   | 1       | 8192       | 70     | 29.4  | 1.26e-6 | 1.20e-6 | 1.90e-6 | 2.00e-6 | 2.92e-6 | 2.89e-6 | 2.95e-6 | 2.99e-6 | 3.03e-6 | 3.23e-6  | 1.94e-6  | 2.09e-6  | 2.16e-6  | 1.53e-6  | 1.36e-6  | 1.19e-6  | 9.12e-6    |
| 1.0e-06       | 64   | 1       | 8192       | 70     | 24.7  | 1.70e-6 | 1.64e-6 | 2.75e-6 | 2.81e-6 | 4.55e-6 | 4.57e-6 | 4.62e-6 | 4.65e-6 | 4.66e-6 | 4.76e-6  | 2.85e-6  | 2.95e-6  | 3.02e-6  | 1.96e-6  | 1.81e-6  | 1.60e-6  | 1.36e-5    |
| 5.0e-06       | 64   | 1       | 8192       | 70     | 32.3  | 5.07e-6 | 5.09e-6 | 1.01e-5 | 1.00e-5 | 1.91e-5 | 1.92e-5 | 1.95e-5 | 1.94e-5 | 1.94e-5 | 1.92e-5  | 9.99e-6  | 9.79e-6  | 9.93e-6  | 5.14e-6  | 5.14e-6  | 4.95e-6  | 5.35e-5    |
| 5.0e-07       | 1    | 5       | 8192       | 70     | 23.6  | 2.12e-6 | 2.46e-6 | 3.98e-6 | 4.06e-6 | 7.29e-6 | 7.17e-6 | 6.73e-6 | 6.88e-6 | 6.85e-6 | 6.63e-6  | 4.18e-6  | 4.02e-6  | 4.04e-6  | 2.40e-6  | 2.11e-6  | 1.71e-6  | 1.98e-5    |
| 1.0e-06       | 1    | 5       | 8192       | 70     | 22.7  | 2.56e-6 | 2.95e-6 | 5.38e-6 | 5.09e-6 | 1.12e-5 | 1.03e-5 | 1.07e-5 | 1.03e-5 | 1.04e-5 | 9.82e-6  | 5.22e-6  | 4.57e-6  | 4.81e-6  | 2.61e-6  | 2.68e-6  | 2.28e-6  | 2.86e-5    |
| 5.0e-06       | 1    | 5       | 8192       | 70     | 28.3  | 3.26e-6 | 3.52e-6 | 8.15e-6 | 7.38e-6 | 2.43e-5 | 2.55e-5 | 2.97e-5 | 2.82e-5 | 2.74e-5 | 2.17e-5  | 7.36e-6  | 6.32e-6  | 6.34e-6  | 2.91e-6  | 3.09e-6  | 3.05e-6  | 6.67e-5    |
| 5.0e-07       | 2    | 5       | 8192       | 70     | 21.5  | 2.08e-6 | 2.26e-6 | 3.68e-6 | 3.70e-6 | 6.37e-6 | 6.18e-6 | 5.90e-6 | 6.71e-6 | 6.31e-6 | 6.36e-6  | 3.97e-6  | 4.10e-6  | 4.13e-6  | 2.34e-6  | 2.31e-6  | 1.61e-6  | 1.84e-5    |
| 1.0e-06       | 2    | 5       | 8192       | 70     | 21.3  | 2.59e-6 | 2.88e-6 | 4.91e-6 | 4.88e-6 | 9.68e-6 | 9.66e-6 | 9.66e-6 | 1.01e-5 | 9.77e-6 | 9.46e-6  | 5.14e-6  | 4.91e-6  | 5.09e-6  | 2.81e-6  | 2.79e-6  | 2.18e-6  | 2.70e-5    |
| 5.0e-06       | 2    | 5       | 8192       | 70     | 25.4  | 3.53e-6 | 3.95e-6 | 9.20e-6 | 7.39e-6 | 2.89e-5 | 3.24e-5 | 3.71e-5 | 3.27e-5 | 3.03e-5 | 2.56e-5  | 7.25e-6  | 6.20e-6  | 6.61e-6  | 3.22e-6  | 3.26e-6  | 3.42e-6  | 7.90e-5    |
| 5.0e-07       | 4    | 5       | 8192       | 70     | 20.1  | 2.06e-6 | 2.02e-6 | 3.46e-6 | 3.51e-6 | 5.60e-6 | 5.59e-6 | 5.54e-6 | 5.97e-6 | 5.69e-6 | 5.84e-6  | 3.94e-6  | 4.02e-6  | 4.11e-6  | 2.58e-6  | 2.15e-6  | 1.67e-6  | 1.70e-5    |
| 1.0e-06       | 4    | 5       | 8192       | 70     | 19.4  | 2.64e-6 | 2.63e-6 | 4.80e-6 | 4.77e-6 | 8.84e-6 | 8.88e-6 | 8.72e-6 | 9.10e-6 | 8.96e-6 | 8.84e-6  | 5.04e-6  | 5.03e-6  | 5.20e-6  | 3.06e-6  | 2.64e-6  | 2.18e-6  | 2.52e-5    |
| 5.0e-06       | 4    | 5       | 8192       | 70     | 25.1  | 3.94e-6 | 4.31e-6 | 1.07e-5 | 8.78e-6 | 3.18e-5 | 3.54e-5 | 3.79e-5 | 3.48e-5 | 3.38e-5 | 2.88e-5  | 8.13e-6  | 7.29e-6  | 7.66e-6  | 3.63e-6  | 3.53e-6  | 3.52e-6  | 8.56e-5    |
| 5.0e-07       | 8    | 5       | 8192       | 70     | 19.5  | 1.83e-6 | 1.63e-6 | 2.96e-6 | 3.06e-6 | 4.47e-6 | 4.53e-6 | 4.64e-6 | 4.98e-6 | 4.80e-6 | 4.97e-6  | 3.42e-6  | 3.56e-6  | 3.67e-6  | 2.15e-6  | 1.98e-6  | 1.47e-6  | 1.44e-5    |
| 1.0e-06       | 8    | 5       | 8192       | 70     | 17.6  | 2.39e-6 | 2.22e-6 | 4.11e-6 | 4.20e-6 | 7.18e-6 | 7.33e-6 | 7.33e-6 | 7.58e-6 | 7.44e-6 | 7.44e-6  | 4.54e-6  | 4.56e-6  | 4.78e-6  | 2.76e-6  | 2.43e-6  | 2.02e-6  | 2.13e-5    |
| 5.0e-06       | 8    | 5       | 8192       | 70     | 23.5  | 4.12e-6 | 4.31e-6 | 1.08e-5 | 9.52e-6 | 2.86e-5 | 3.13e-5 | 3.20e-5 | 3.07e-5 | 3.00e-5 | 2.72e-5  | 8.75e-6  | 7.67e-6  | 8.11e-6  | 3.73e-6  | 3.61e-6  | 3.69e-6  | 7.67e-5    |
| 5.0e-07       | 64   | 5       | 8192       | 70     | 21.7  | 1.53e-6 | 1.33e-6 | 2.30e-6 | 2.40e-6 | 3.43e-6 | 3.18e-6 | 3.27e-6 | 3.66e-6 | 3.55e-6 | 3.88e-6  | 2.53e-6  | 2.75e-6  | 2.83e-6  | 1.90e-6  | 1.63e-6  | 1.24e-6  | 1.09e-5    |
| 1.0e-06       | 64   | 5       | 8192       | 70     | 18.2  | 1.86e-6 | 1.69e-6 | 3.01e-6 | 3.03e-6 | 4.81e-6 | 4.78e-6 | 4.81e-6 | 5.03e-6 | 4.94e-6 | 5.12e-6  | 3.30e-6  | 3.58e-6  | 3.61e-6  | 2.33e-6  | 2.01e-6  | 1.62e-6  | 1.48e-5    |
| 5.0e-06       | 64   | 5       | 8192       | 70     | 24.4  | 4.22e-6 | 4.37e-6 | 9.53e-6 | 9.35e-6 | 1.89e-5 | 1.91e-5 | 1.93e-5 | 1.92e-5 | 1.91e-5 | 1.88e-5  | 9.34e-6  | 8.88e-6  | 9.02e-6  | 4.39e-6  | 4.13e-6  | 3.75e-6  | 5.19e-5    |
| 5.0e-07       | 1    | 10      | 8192       | 70     | 22.6  | 2.15e-6 | 2.47e-6 | 4.14e-6 | 4.27e-6 | 7.84e-6 | 7.44e-6 | 7.12e-6 | 7.00e-6 | 7.13e-6 | 6.80e-6  | 4.20e-6  | 4.08e-6  | 4.17e-6  | 2.44e-6  | 2.07e-6  | 1.72e-6  | 2.06e-5    |
| 1.0e-06       | 1    | 10      | 8192       | 70     | 22.8  | 2.55e-6 | 2.93e-6 | 5.39e-6 | 5.18e-6 | 1.14e-5 | 1.02e-5 | 1.06e-5 | 1.00e-5 | 1.01e-5 | 9.49e-6  | 4.97e-6  | 4.60e-6  | 4.70e-6  | 2.62e-6  | 2.70e-6  | 2.23e-6  | 2.82e-5    |
| 5.0e-06       | 1    | 10      | 8192       | 70     | 56.5  | 3.36e-6 | 3.86e-6 | 8.75e-6 | 8.91e-6 | 2.63e-5 | 2.71e-5 | 3.34e-5 | 3.03e-5 | 2.69e-5 | 2.65e-5  | 9.17e-6  | 7.89e-6  | 8.05e-6  | 3.48e-6  | 3.36e-6  | 3.23e-6  | 7.29e-5    |
| 5.0e-07       | 2    | 10      | 8192       | 70     | 20.8  | 2.04e-6 | 2.35e-6 | 3.76e-6 | 3.84e-6 | 6.71e-6 | 6.47e-6 | 6.26e-6 | 6.99e-6 | 6.57e-6 | 6.62e-6  | 4.04e-6  | 4.23e-6  | 4.27e-6  | 2.39e-6  | 2.39e-6  | 1.68e-6  | 1.92e-5    |
| 1.0e-06       | 2    | 10      | 8192       | 70     | 20.6  | 2.55e-6 | 2.87e-6 | 4.87e-6 | 4.88e-6 | 9.71e-6 | 9.62e-6 | 9.64e-6 | 9.98e-6 | 9.72e-6 | 9.43e-6  | 5.14e-6  | 4.93e-6  | 5.08e-6  | 2.78e-6  | 2.86e-6  | 2.12e-6  | 2.69e-5    |
| 5.0e-06       | 2    | 10      | 8192       | 70     | 248.9 | 3.60e-6 | 4.18e-6 | 9.22e-6 | 7.90e-6 | 2.94e-5 | 2.90e-5 | 3.13e-5 | 2.83e-5 | 2.65e-5 | 2.30e-5  | 8.39e-6  | 7.47e-6  | 7.91e-6  | 4.52e-6  | 3.89e-6  | 3.46e-6  | 7.16e-5    |
| 5.0e-07       | 4    | 10      | 8192       | 70     | 19.4  | 1.50e-6 | 1.37e-6 | 2.53e-6 | 2.54e-6 | 4.10e-6 | 4.09e-6 | 3.98e-6 | 4.31e-6 | 4.15e-6 | 4.18e-6  | 2.95e-6  | 2.93e-6  | 2.97e-6  | 1.84e-6  | 1.53e-6  | 1.12e-6  | 1.24e-5    |
| 1.0e-06       | 4    | 10      | 8192       | 70     | 18.5  | 2.66e-6 | 2.65e-6 | 4.84e-6 | 4.87e-6 | 9.08e-6 | 8.98e-6 | 8.76e-6 | 9.23e-6 | 9.10e-6 | 8.93e-6  | 5.14e-6  | 5.08e-6  | 5.24e-6  | 3.03e-6  | 2.67e-6  | 2.17e-6  | 2.55e-5    |
| 5.0e-06       | 4    | 10      | 8192       | 70     | 21.7  | 3.83e-6 | 3.99e-6 | 9.47e-6 | 7.80e-6 | 2.87e-5 | 3.09e-5 | 3.26e-5 | 2.94e-5 | 2.86e-5 | 2.39e-5  | 7.50e-6  | 6.90e-6  | 7.10e-6  | 3.57e-6  | 3.48e-6  | 3.27e-6  | 7.39e-5    |
| 5.0e-07       | 8    | 10      | 8192       | 70     | 17.7  | 1.90e-6 | 1.80e-6 | 3.15e-6 | 3.23e-6 | 4.86e-6 | 5.02e-6 | 4.91e-6 | 5.43e-6 | 5.12e-6 | 5.28e-6  | 3.79e-6  | 3.83e-6  | 3.99e-6  | 2.33e-6  | 2.02e-6  | 1.48e-6  | 1.55e-5    |
| 1.0e-06       | 8    | 10      | 8192       | 70     | 17.0  | 2.36e-6 | 2.32e-6 | 4.22e-6 | 4.24e-6 | 7.38e-6 | 7.62e-6 | 7.43e-6 | 7.82e-6 | 7.59e-6 | 7.55e-6  | 4.78e-6  | 4.74e-6  | 4.93e-6  | 2.81e-6  | 2.48e-6  | 1.95e-6  | 2.19e-5    |
| 5.0e-06       | 8    | 10      | 8192       | 70     | 22.2  | 3.79e-6 | 3.92e-6 | 9.67e-6 | 8.43e-6 | 2.64e-5 | 2.86e-5 | 2.93e-5 | 2.78e-5 | 2.70e-5 | 2.38e-5  | 7.76e-6  | 6.88e-6  | 7.40e-6  | 3.63e-6  | 3.44e-6  | 3.31e-6  | 6.96e-5    |
| 5.0e-07       | 64   | 10      | 8192       | 70     | 19.4  | 1.55e-6 | 1.40e-6 | 2.44e-6 | 2.52e-6 | 3.63e-6 | 3.47e-6 | 3.53e-6 | 3.99e-6 | 3.82e-6 | 4.13e-6  | 2.80e-6  | 3.07e-6  | 3.13e-6  | 2.07e-6  | 1.70e-6  | 1.26e-6  | 1.17e-5    |
| 1.0e-06       | 64   | 10      | 8192       | 70     | 16.6  | 1.95e-6 | 1.73e-6 | 3.11e-6 | 3.13e-6 | 4.95e-6 | 4.93e-6 | 4.96e-6 | 5.24e-6 | 5.11e-6 | 5.27e-6  | 3.55e-6  | 3.88e-6  | 3.88e-6  | 2.46e-6  | 2.06e-6  | 1.60e-6  | 1.54e-5    |
| 5.0e-06       | 64   | 10      | 8192       | 70     | 16.0  | 3.92e-6 | 4.03e-6 | 9.15e-6 | 8.89e-6 | 1.87e-5 | 1.89e-5 | 1.91e-5 | 1.90e-5 | 1.89e-5 | 1.85e-5  | 8.94e-6  | 8.47e-6  | 8.55e-6  | 4.17e-6  | 3.82e-6  | 3.26e-6  | 5.09e-5    |

# DP-LDM

For comparison, hyperparameters for DP-LDM models trained on Celeba64 presented in Table 2 of the paper.

| Learning Rate | Epsilon | Batch Size | Epochs | FID  | Layer 1 | Layer 2 | Layer 3 | Layer 4 | Layer 5 | Layer 6 | Layer 7 | Layer 8 | Layer 9 | Layer 10 | Layer 11 | Layer 12 | Layer 13 | Layer 14 | Layer 15 | Layer 16 | All Params |
|---------------|---------|------------|--------|------|---------|---------|---------|---------|---------|---------|---------|---------|---------|----------|----------|----------|----------|----------|----------|----------|------------|
| 1.0e-07       | 1       | 8192       | 70     | 21.1 | 7.70    | 7.81    | 15.56   | 15.58   | 31.14   | 31.11   | 31.13   | 31.09   | 31.12   | 31.16    | 15.61    | 15.61    | 15.56    | 7.75     | 7.73     | 7.72     | 85.60      |
| 1.0e-07       | 5       | 8192       | 70     | 16.1 | 7.52    | 7.76    | 15.57   | 15.63   | 31.17   | 31.14   | 31.15   | 31.13   | 31.16   | 31.24    | 15.81    | 15.85    | 15.82    | 7.90     | 7.65     | 7.37     | 85.77      |
| 1.0e-07       | 10      | 8192       | 70     | 14.3 | 7.32    | 7.66    | 15.57   | 15.65   | 31.19   | 31.16   | 31.16   | 31.15   | 31.19   | 31.30    | 15.99    | 16.06    | 16.03    | 7.97     | 7.53     | 7.00     | 85.89      |