from flan_paraphrase import run
import random
import json
import os

def main():
    params = {
        "model": "gpt-4",
        "n": 3,
        "temperature": 0.8,
        "max_tokens": 250,
    }
    seed = 42
    num_tasks = 5200

    prompts = [
        ("Paraphrase this sentence:\n\n", "Paraphrased sentence:\n\n"),
        ("Paraphrase this instruction into a longer sentence\n\n\n", "New sentence:\n"),
        ("You are given an instruction:\n\n", "Now, paraphrase it into a new instruction with equivalent meaning:\n\n"),
    ]

    random.seed(seed)
    alpaca_data = json.load(open("./data/alpaca_data.json", "r"))
    tasks_idxs = random.sample(range(len(alpaca_data)), num_tasks)
    uri = "https://api.openai.com/v1/chat/completions"

    inputs = [(str(idx), alpaca_data[idx]["instruction"]) for idx in tasks_idxs]
    run(inputs, prompts, "./results/alpaca-paraphrases", uri, **params)


if __name__ == "__main__":
    main()
