import os
import json
import requests
import openai
from tqdm import tqdm


def run(inputs, output_dir, uri, **kwargs):

    if not os.path.exists(output_dir):
        os.makedirs(output_dir, exist_ok=True)

    json.dump(kwargs, open(os.path.join(output_dir, "params.json"), "w"))
    for k, v in kwargs.items():
        print(k+':'+str(v))

    openai.organization = "your-organization-key"
    openai.api_key = "your-api-key"
    headers = {'Content-Type': 'application/json', 'Authorization': 'Bearer {}'.format(openai.api_key)}

    print("Sending Requests to OpenAI...")
    for idx, prompt in tqdm(enumerate(inputs)):
        if uri == "https://api.openai.com/v1/chat/completions":
            data = json.dumps(
                {
                    "messages": [
                        {"role": "system", "content": "You are a helpful assistant"},
                        {"role": "user", "content": prompt}
                    ],
                    **kwargs
                })
        else:
            data = json.dumps({"prompt": prompt, **kwargs})
        response = requests.post(uri, headers=headers, data=data)
        json.dump(response.json(), open(os.path.join(output_dir, "result_{}.json".format(idx + 1)), "w"))


def main():
    params = {
        "model": "gpt-4",
        "n": 1,
        "temperature": 0.3,
        "max_tokens": 512,
    }

    uri = "https://api.openai.com/v1/chat/completions"
    # uri = "https://api.openai.com/v1/completions"

    file = "./data/flan2021.json"
    prefix = "You are provided with the utterance of a specific task and I need you to paraphrase it. The actual input, question, and examples in the task should not be changed. You should only paraphrase the instructions. Task:\n\n\n"
    suffix = "\n\n\nThe paraphrased utterance:\n\n\n"

    lines = json.load(open(file, "r"))
    import random
    random.shuffle(lines)

    lines = lines[:5]
    json.dump(lines, open("./results/flan2021_sample.json", "w"))
    lines = [line["input_text"] for line in lines]

    inputs = [prefix + line + suffix for line in lines]

    run(inputs, os.path.join("results", file.split("/")[-1].replace(".json", "")), uri, **params)


if __name__ == "__main__":
    main()
