class AlpacaTemplates:

    def alpaca_template_with_input(self, instruction, inputs, answer, label_space):
        input_text = "Below is an instruction that describes a task, paired with an input that provides further " \
                     "context. Write a response that appropriately completes the request.\n\n### Instruction:\n" \
                     "{instruction}\n\n### Input:\n{input}\n\n### Response:".format(instruction=instruction,
                                                                                    input=inputs)
        output_text = answer
        label_space = label_space
        return_dict = {"input_text": input_text, "output_text": output_text, "label_space": label_space}
        return return_dict

    def alpaca_template_without_input(self, instruction, answer, label_space):
        input_text = "Below is an instruction that describes a task, paired with an input that provides further " \
                     "context. Write a response that appropriately completes the request.\n\n### Instruction:\n" \
                     "{instruction}\n\n### Response:".format(instruction=instruction)
        output_text = answer
        label_space = label_space
        return_dict = {"input_text": input_text, "output_text": output_text, "label_space": label_space}
        return return_dict

    def alpaca_multiple_choice(self, item, instruction):
        question, answer, options = item["question"], item["answer"], item["options"]
        item_names = [chr(x) for x in range(ord("A"), ord("Z") + 1)][:len(options)]
        _options = ""
        for item, option in zip(item_names, options):
            _options += "\n({}) {}".format(item, option)
        answer = item_names[options.index(answer)]
        inputs = "Question: {question}{_options}".format(question=question, _options=_options)
        label_space = item_names
        return self.alpaca_template_with_input(instruction, inputs, answer, label_space)
    
    def alpaca_nlg(self, item, instruction):
        input_text, output_text = item["input_text"], item["output_text"]
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)
    
    def alpaca_trans(self, item, instruction):
        input_text, output_text = item["sent1"], item["sent2"]
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)
    
    def alpaca_translation_1(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate the text below into German."
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)
    
    def alpaca_translation_2(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate the text below into German."
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)
    
    def alpaca_translation_3(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate \"{input_text}\" into German.".format(input_text=input_text)
        return self.alpaca_template_without_input(instruction, output_text, None)
    
    def alpaca_translation_4(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate the sentence in German."
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)
    
    def alpaca_translation_5(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate the following sentence into German: \"{input_text}\"".format(input_text=input_text)
        return self.alpaca_template_without_input(instruction, output_text, None)
    
    def alpaca_translation_6(self, item):
        input_text, output_text = item["sent1"], item["sent2"]
        instruction = "Translate the given paragraph into German."
        inputs = "{input_text}".format(input_text=input_text)
        return self.alpaca_template_with_input(instruction, inputs, output_text, None)

    def alpaca_binary_classification(self, item, instruction, label_space):
        question, answer = item["question"], item["answer"]
        inputs = "{question}".format(question=question)
        return self.alpaca_template_with_input(instruction, inputs, answer, label_space)
    
    def alpaca_summarization_1(self, item):
        instruction = "Generate a summary of the given article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_2(self, item):
        instruction = "Provide a summary for the passage given below."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_3(self, item):
        instruction = "Write a one-sentence summary of the following news article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_4(self, item):
        instruction = "Construct a concise summary of the following article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_5(self, item):
        instruction = "Generate a 1-sentence summary on the following news article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_6(self, item):
        instruction = "Create a new headline that is witty and summarizes the article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_7(self, item):
        instruction = "Create a tweet summarizing the following news article in 140 characters or less."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_8(self, item):
        instruction = "Analyze the following news article and provide a brief summary."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_9(self, item):
        instruction = "Create a 1-2 sentence summary of the following article"
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_10(self, item):
        instruction = "Write a summary of the given article. Make sure it is less than 100 words and it accurately reflects the key points of the article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_11(self, item):
        instruction = "Provide a short summary of the article content in fewer than 100 words."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_12(self, item):
        instruction = "Generate an appropriate summary to the following blog post"
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_13(self, item):
        instruction = "Create a summary of the text below"
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_14(self, item):
        instruction = "Summarize the following article. Output a summarization of 5 sentences or fewer."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_15(self, item):
        instruction = "Given a article, summarize its main points in 100 wrods."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_16(self, item):
        instruction = "Write a concise summary of the provided text."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_17(self, item):
        instruction = "Given the following passage, summarize it."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_18(self, item):
        instruction = "Create a new headline summarizing this article."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_19(self, item):
        instruction = "Given the following text, summarize it in one sentence."
        return self.alpaca_nlg(item, instruction)
    
    def alpaca_summarization_20(self, item):
        instruction = "Generate a 3-word phrase that summarizes the following text."
        return self.alpaca_nlg(item, instruction)

    def alpaca_multiple_choice_1(self, item):
        instruction = "Select the correct letter in the parentheses."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_2(self, item):
        instruction = "Select the correct option from the following choices."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_3(self, item):
        instruction = "Answer this multiple choice question."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_4(self, item):
        instruction = "Read the answer choices and select the correct one."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_5(self, item):
        instruction = "Identify the correct answer from the choices below."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_6(self, item):
        instruction = "Determine which choice is correct and output it."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_7(self, item):
        instruction = "Refer to the given input and identify the correct answer."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_8(self, item):
        instruction = "From the given three options, select the one most relevant to the given input."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_9(self, item):
        instruction = "Select the most optimal response."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_10(self, item):
        instruction = "Read the answer choices and select the correct one."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_11(self, item):
        instruction = "Select the best answer out of given options."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_12(self, item):
        instruction = "Determine which of these options is the correct answer."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_13(self, item):
        instruction = "Choose the best option."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_14(self, item):
        instruction = "Choose the best option."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_15(self, item):
        instruction = "Select the best answer."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_16(self, item):
        instruction = "Choose the correct answer."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_17(self, item):
        instruction = "Select the correct answer from a list."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_18(self, item):
        instruction = "Choose the best answer."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_19(self, item):
        instruction = "Choose the statement that best suits the given context."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_multiple_choice_20(self, item):
        instruction = "Answer the question based on common sense and your knowledge."
        return self.alpaca_multiple_choice(item, instruction)

    def alpaca_binary_classification_1(self, item):
        instruction = "Determine if this claim is true or false:"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])
    
    def alpaca_binary_classification_2(self, item):
        instruction = "Is the following sentence true or false?"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])

    def alpaca_binary_classification_3(self, item):
        instruction = "Identify whether the following phrase is a true or false statement"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])
    
    def alpaca_binary_classification_4(self, item):
        instruction = "Check if the following statement is true or false:"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])
        
    def alpaca_binary_classification_5(self, item):
        instruction = "Classify the following statement as true or false:"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])
    
    def alpaca_binary_classification_6(self, item):
        instruction = "Classify the following statement as true or false:"
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])

    def alpaca_binary_classification_7(self, item):
        instruction = "Do a fact check to confirm the accuracy of the statement and output true or false."
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])

    def alpaca_binary_classification_8(self, item):
        instruction = "Label whether an input sentence is true or false."
        return self.alpaca_binary_classification(item, instruction, ["True", "False"])

    # Answer yes or now
    def alpaca_binary_classification_9(self, item):
        instruction = "Indicate a yes or no answer to the given statement.."
        return self.alpaca_binary_classification(item, instruction, ["Yes", "No"])

    def alpaca_binary_classification_10(self, item):
        instruction = "Evaluate the following proposal as a yes or no response."
        return self.alpaca_binary_classification(item, instruction, ["Yes", "No"])

    def alpaca_binary_classification_11(self, item):
        instruction = "Respond to the following statement with a yes or no."
        return self.alpaca_binary_classification(item, instruction, ["Yes", "No"])
    
    # Dialog Specific
    def alpaca_dialog_1(self, item):
        instruction = "Identify the speaker of these lines.."
        return self.alpaca_binary_classification(item, instruction, ["same", "different"])
    
    def alpaca_dialog_2(self, item):
        instruction = "Given a dialogue, identify the speaker."
        return self.alpaca_binary_classification(item, instruction, ["same", "different"])





