@echo off
echo Installation and configuration of needed software packages.
echo ===========================================================
echo.
echo.

set root=%cd%

:cuda
echo.
set ovcpath="%root%\external\OpenCV"
set /P c=Is CUDA 11.2 already installed [Y/N]?
if /I "%c%" EQU "Y" goto :arrayfire
if /I "%c%" EQU "N" goto :cudaInstall

:cudaInstall
echo Downloading CUDA...
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1yTF_Aj34p0CMrYI_SIzXrGquK3p2EZQy" ".\packages\cuda_11.2.0_win10_network.exe"
echo Installing CUDA...
call "%root%\packages\cuda_11.2.0_win10_network.exe"

:arrayfire
echo.
set /P c=Is ArrayFire already installed [Y/N]?
if /I "%c%" EQU "Y" goto :boost
if /I "%c%" EQU "N" goto :arrayfireInstall

:arrayfireInstall
echo Downloading ArrayFire...
powershell -Command "Invoke-WebRequest http://arrayfire.s3.amazonaws.com/3.8.0/ArrayFire-v3.8.0-CUDA-11.2.exe -OutFile %root%\packages\ArrayFire-v3.8.0-CUDA-11.2.exe"
echo Installing ArrayFire...
call "%root%\packages\ArrayFire-v3.8.0-CUDA-11.2.exe"

:boost
echo.
echo Downloading Boost...
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1oYeA5SXPgmC3BhV05P7qfKsDCKlsPNFj" ".\packages\boost-1_71.zip"
echo Extracting Boost. Be patient, this will take a while...
powershell.exe -nologo -noprofile -command "& { Add-Type -A 'System.IO.Compression.FileSystem'; [IO.Compression.ZipFile]::ExtractToDirectory('.\packages\boost-1_71.zip', '.\external'); }"
echo Done.
echo.

:addPack
echo.
echo Downloading additional packages...
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1DM2t3BF1NR-g1uCMTY3c57UZX0SKDIg-" ".\packages\OpenCV.zip"
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1hFUCi44apK_pVEU1OeyFT7Q_erQITDD4" ".\packages\tbb2018.zip"
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "12jrREG2yOa6xxtx4I7qMoVCzKxQfOokD" ".\packages\zlib_1.2.1.1.zip"
echo Extracting packages...
powershell.exe -nologo -noprofile -command "& { Add-Type -A 'System.IO.Compression.FileSystem'; [IO.Compression.ZipFile]::ExtractToDirectory('.\packages\OpenCV.zip', '.\external'); }"
powershell.exe -nologo -noprofile -command "& { Add-Type -A 'System.IO.Compression.FileSystem'; [IO.Compression.ZipFile]::ExtractToDirectory('.\packages\tbb2018.zip', '.\external'); }"
powershell.exe -nologo -noprofile -command "& { Add-Type -A 'System.IO.Compression.FileSystem'; [IO.Compression.ZipFile]::ExtractToDirectory('.\packages\zlib_1.2.1.1.zip', '.\external'); }"

:addData
echo.
echo Downloading training data...
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1_jA_UYeFPYKCNHh8kObD-hhEELan_0B8" ".\data\electricity.txt"
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1HCEog9dlCDPaXL2Vl1U54q61GC6a-8L9" ".\data\golfswing.mat"
powershell -ExecutionPolicy RemoteSigned -inputformat none -file ".\packages\googleDriveDownload.ps1" "1eAOaYr440UvXl9AeIN9EYTT7f-ryHkdb" ".\data\traffic.txt"
echo.

echo Setting environment variables...
set nepath="%root%"
set boostpath="%root%\external\boost-1_71"
setx BOOST_HOME %boostpath%
setx NE_PATH %nepath%
setx OPENCV_HOME %ovcpath%
REM setx ASSIMP_HOME %assimpcpath%
for /F "tokens=2* delims= " %%f IN ('reg query HKCU\Environment /v PATH ^| findstr /i path') do set OLD_SYSTEM_PATH=%%g
setx PATH "C:\Program Files\ArrayFire\v3\lib;%OLD_SYSTEM_PATH%"

REM for /f "usebackq tokens=2,*" %A in ('reg query HKCU\Environment /v PATH') do set my_user_path=%B
REM setx PATH "C:\Program Files\ArrayFire\v3\lib;%my_user_path%" 
echo Done.
pause