/**
File:		NECore/DataTypes/NeArray2.inl

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

template <typename T>
Array2<T>::Array2(size_t bound0, size_t bound1)
	:
	mBound0(bound0),
	mBound1(bound1),
	mObjects(bound0 * bound1),
	mIndirect1(bound1)
{
	SetPointers(mObjects.data());
}

template <typename T>
Array2<T>::Array2(size_t bound0, size_t bound1, T* objects)
	:
	mBound0(bound0),
	mBound1(bound1),
	mIndirect1(bound1)
{
	SetPointers(objects);
}

template <typename T>
Array2<T>::Array2()
	:
	mBound0(0),
	mBound1(0)
{
}

template <typename T>
Array2<T>::Array2(Array2 const& other)
{
	*this = other;
}

template <typename T>
Array2<T>& Array2<T>::operator=(Array2 const& other)
{
	// The copy is valid whether or not other.mObjects has elements.
	mObjects = other.mObjects;
	SetPointers(other);
	return *this;
}

template <typename T>
Array2<T>::Array2(Array2&& other)
{
	*this = std::move(other);
}

template <typename T>
Array2<T>& Array2<T>::operator=(Array2&& other)
{
	// The move is valid whether or not other.mObjects has elements.
	mObjects = std::move(other.mObjects);
	SetPointers(other);
	return *this;
}

template <typename T> inline
size_t Array2<T>::GetBound0() const
{
	return mBound0;
}

template <typename T> inline
size_t Array2<T>::GetBound1() const
{
	return mBound1;
}

template <typename T> inline
T const* Array2<T>::operator[] (int row) const
{
	return mIndirect1[row];
}

template <typename T> inline
T* Array2<T>::operator[] (int row)
{
	return mIndirect1[row];
}

template <typename T>
void Array2<T>::SetPointers(T* objects)
{
	for (size_t i1 = 0; i1 < mBound1; ++i1)
	{
		size_t j0 = mBound0 * i1;  // = bound0 * (i1 + j1) where j1 = 0
		mIndirect1[i1] = &objects[j0];
	}
}

template <typename T>
void Array2<T>::SetPointers(Array2 const& other)
{
	mBound0 = other.mBound0;
	mBound1 = other.mBound1;
	mIndirect1.resize(mBound1);

	if (mBound0 > 0)
	{
		// The objects are owned.
		SetPointers(mObjects.data());
	}
	else if (mIndirect1.size() > 0)
	{
		// The objects are not owned.
		SetPointers(other.mIndirect1[0]);
	}
	// else 'other' is an empty Array2.
}