/**
File:		NECore/DataTypes/NeArray3.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <cstddef>
#include <vector>

namespace NeuralEngine
{

	template <typename T>

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// <summary>
	///		The Array3 class represents a 3-dimensional array that minimizes the number
	/// 	of new and delete calls.  The T objects are stored in a contiguous array.		
	/// </summary>
	///
	/// <remarks>	Hmetal T, 04.08.2016. </remarks>
	////////////////////////////////////////////////////////////////////////////////////////////////////
	class Array3
	{
	public:

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Constructor. </summary>
		/// 
		/// <note>
		///		Construction.  The first constructor generates an array of objects that
		///		are owned by Array3. The array has bound0 columns,
		/// 	bound1 rows, and bound2 slices.
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		///
		/// <param name="bound0">	The bound 0. </param>
		/// <param name="bound1">	The first bound. </param>
		/// <param name="bound2">	The second bound. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array3(size_t bound0, size_t bound1, size_t bound2);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Constructor. </summary>
		/// 
		/// <note>
		///		The second constructor is given an array of
		/// 	objects that are owned by the caller.  The array has bound0 columns,
		/// 	bound1 rows, and bound2 slices.
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		///
		/// <param name="bound0"> 	The bound 0. </param>
		/// <param name="bound1"> 	The first bound. </param>
		/// <param name="bound2"> 	The second bound. </param>
		/// <param name="objects">	[in,out] If non-null, the objects. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array3(size_t bound0, size_t bound1, size_t bound2, T* objects);


		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Default constructor. </summary>
		/// 
		/// <note>
		///		Support for dynamic resizing, copying, or moving.  If 'other' does
		/// 	not own the original 'objects', they are not copied by the assignment
		/// 	operator.
		/// </note>
		///
		/// <remarks>	Hmetal T, 04.08.2016. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Array3();
		Array3(Array3 const&);
		Array3& operator=(Array3 const&);
		Array3(Array3&&);
		Array3& operator=(Array3&&);

		// Access to the array.  Sample usage is
		//   Array3<T> myArray(4, 3, 2);
		//   T** slice1 = myArray[1];
		//   T* slice1row2 = myArray[1][2];
		//   T slice1Row2Col3 = myArray[1][2][3];
		inline size_t GetBound0() const;
		inline size_t GetBound1() const;
		inline size_t GetBound2() const;
		inline T* const* operator[] (int slice) const;
		inline T** operator[] (int slice);

	private:
		void SetPointers(T* objects);
		void SetPointers(Array3 const& other);

		size_t mBound0, mBound1, mBound2;
		std::vector<T> mObjects;
		std::vector<T*> mIndirect1;
		std::vector<T**> mIndirect2;
	};
#include "NeArray3.inl"
}