/**
File:		NEApplications/Application/NeEnvironment.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <cstdarg>
#include <string>
#include <vector>

namespace NeuralEngine
{

	class NE_IMPEXP Environment
	{
	public:

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Default constructor. </summary>
		///
		/// <remarks>	Hmetal T, 08.08.2016. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		Environment();

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Destructor. </summary>
		///
		/// <remarks>	Hmetal T, 08.08.2016. </remarks>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		~Environment();

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Get the string corresponding to an environment variable. </summary>
		///
		/// <remarks>	Hmetal T, 08.08.2016. </remarks>
		///
		/// <param name="name">	The name. </param>
		///
		/// <returns>	The variable. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		std::string GetVariable(std::string const& name);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Gets number directories. </summary>
		/// 
		/// <note>
		///		Support for paths to locate files.  For platform independence, use
		/// 	"/" for the path separator.  The input 'directory' will automatically
		/// 	be appended with a trailing "/" if it does not end in '/' or '\\'. 
		/// 	The Insert*/Remove* functions return 'true' iff the operation was
		/// 	successful.
		/// </note>
		///
		/// <remarks>	Hmetal T, 08.08.2016. </remarks>
		///
		/// <returns>	The number directories. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		int GetNumDirectories() const;
		std::string Get(int i) const;
		bool Insert(std::string const& directory);
		bool Remove(std::string const& directory);
		void RemoveAll();

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Gets a path. </summary>
		/// 
		/// <note>
		///		The GetPath function searches the list of directories and returns the
		/// 	fully decorated file name if the file exists and can be opened for
		/// 	reading.
		/// </note>
		///
		/// <remarks>	Hmetal T, 08.08.2016. </remarks>
		///
		/// <param name="name">	The name. </param>
		///
		/// <returns>	The path. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		std::string GetPath(std::string const& name) const;

	private:
		// The list of directories for GetPath to search.
		std::vector<std::string> mDirectories;
	};

}
