/**
File:		NECore/DataTypes/NeLexicoArray2.inl

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

// The array dimensions are known at compile time.
template <typename Real, int NumRows, int NumCols>
class LexicoArray2<true, Real, NumRows, NumCols>
{
public:
	inline LexicoArray2(Real* matrix);

	inline int GetNumRows() const;
	inline int GetNumCols() const;
	inline Real& operator()(int r, int c);
	inline Real const& operator()(int r, int c) const;

private:
	Real* mMatrix;
};

template <typename Real, int NumRows, int NumCols>
class LexicoArray2<false, Real, NumRows, NumCols>
{
public:
	inline LexicoArray2(Real* matrix);

	inline int GetNumRows() const;
	inline int GetNumCols() const;
	inline Real& operator()(int r, int c);
	inline Real const& operator()(int r, int c) const;

private:
	Real* mMatrix;
};


template <typename Real> inline
LexicoArray2<true, Real>::LexicoArray2(int numRows, int numCols, Real* matrix)
	:
	mNumRows(numRows),
	mNumCols(numCols),
	mMatrix(matrix)
{
}

template <typename Real> inline
int LexicoArray2<true, Real>::GetNumRows() const
{
	return mNumRows;
}

template <typename Real> inline
int LexicoArray2<true, Real>::GetNumCols() const
{
	return mNumCols;
}

template <typename Real> inline
Real& LexicoArray2<true, Real>::operator()(int r, int c)
{
	return mMatrix[c + mNumCols*r];
}

template <typename Real> inline
Real const& LexicoArray2<true, Real>::operator()(int r, int c) const
{
	return mMatrix[c + mNumCols*r];
}



template <typename Real> inline
LexicoArray2<false, Real>::LexicoArray2(int numRows, int numCols, Real* matrix)
	:
	mNumRows(numRows),
	mNumCols(numCols),
	mMatrix(matrix)
{
}

template <typename Real> inline
int LexicoArray2<false, Real>::GetNumRows() const
{
	return mNumRows;
}

template <typename Real> inline
int LexicoArray2<false, Real>::GetNumCols() const
{
	return mNumCols;
}

template <typename Real> inline
Real& LexicoArray2<false, Real>::operator()(int r, int c)
{
	return mMatrix[r + mNumRows*c];
}

template <typename Real> inline
Real const& LexicoArray2<false, Real>::operator()(int r, int c) const
{
	return mMatrix[r + mNumRows*c];
}



template <typename Real, int NumRows, int NumCols> inline
LexicoArray2<true, Real, NumRows, NumCols>::LexicoArray2(Real* matrix)
	:
	mMatrix(matrix)
{
}

template <typename Real, int NumRows, int NumCols> inline
int LexicoArray2<true, Real, NumRows, NumCols>::GetNumRows() const
{
	return NumRows;
}

template <typename Real, int NumRows, int NumCols> inline
int LexicoArray2<true, Real, NumRows, NumCols>::GetNumCols() const
{
	return NumCols;
}

template <typename Real, int NumRows, int NumCols> inline
Real& LexicoArray2<true, Real, NumRows, NumCols>::operator()(int r, int c)
{
	return mMatrix[c + NumCols*r];
}

template <typename Real, int NumRows, int NumCols> inline
Real const& LexicoArray2<true, Real, NumRows, NumCols>::operator()(int r, int c) const
{
	return mMatrix[c + NumCols*r];
}



template <typename Real, int NumRows, int NumCols> inline
LexicoArray2<false, Real, NumRows, NumCols>::LexicoArray2(Real* matrix)
	:
	mMatrix(matrix)
{
}

template <typename Real, int NumRows, int NumCols> inline
int LexicoArray2<false, Real, NumRows, NumCols>::GetNumRows() const
{
	return NumRows;
}

template <typename Real, int NumRows, int NumCols> inline
int LexicoArray2<false, Real, NumRows, NumCols>::GetNumCols() const
{
	return NumCols;
}

template <typename Real, int NumRows, int NumCols> inline
Real& LexicoArray2<false, Real, NumRows, NumCols>::operator()(int r, int c)
{
	return mMatrix[r + NumRows*c];
}

template <typename Real, int NumRows, int NumCols> inline
Real const& LexicoArray2<false, Real, NumRows, NumCols>::operator()(int r, int c) const
{
	return mMatrix[r + NumRows*c];
}