/**
File:		NECore/InputOutput/NeLogReporter.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <Core/NeLogToFile.h>
#include <Core/NeLogToStdout.h>
#if defined(__MSWINDOWS__)
#include <Core/NeLogToMessageBox.h>
#include <Core/NeLogToOutputWindow.h>
#endif
#include <memory>

namespace NeuralEngine
{

	class NE_IMPEXP LogReporter
	{
	public:
		// Construction and destruction.  Create one of these objects in an
		// application for logging.  The GenerateProject tool creates such code.
		// If you do not want a particular logger, set the flags to
		// LISTEN_FOR_NOTHING and set logFile to "" if you do not want a file.
		~LogReporter();

		LogReporter(std::string const& logFile, int logFileFlags, int logStdoutFlags,
			int logMessageBoxFlags = 0, int logOutputWindowFlags = 0);

	private:
		std::unique_ptr<LogToFile> mLogToFile;
		std::unique_ptr<LogToStdout> mLogToStdout;

#if defined(__MSWINDOWS__)
		std::unique_ptr<LogToMessageBox> mLogToMessageBox;
		std::unique_ptr<LogToOutputWindow> mLogToOutputWindow;
#endif
	};

}
