/**
File:		NECore/Threading/ThreadSafeQueue.inl

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

template <typename Element>
ThreadSafeQueue<Element>::~ThreadSafeQueue()
{
}

template <typename Element>
ThreadSafeQueue<Element>::ThreadSafeQueue(size_t maxNumElements)
	:
	mMaxNumElements(maxNumElements)
{
}

template <typename Element>
size_t ThreadSafeQueue<Element>::GetMaxNumElements() const
{
	size_t maxNumElements;
	mMutex.lock();
	{
		maxNumElements = mMaxNumElements;
	}
	mMutex.unlock();
	return maxNumElements;
}

template <typename Element>
size_t ThreadSafeQueue<Element>::GetNumElements() const
{
	size_t numElements;
	mMutex.lock();
	{
		numElements = mQueue.size();
	}
	mMutex.unlock();
	return numElements;
}

template <typename Element>
bool ThreadSafeQueue<Element>::Push(Element const& element)
{
	bool pushed;
	mMutex.lock();
	{
		if (mQueue.size() < mMaxNumElements)
		{
			mQueue.push(element);
			pushed = true;
		}
		else
		{
			pushed = false;
		}
	}
	mMutex.unlock();
	return pushed;
}

template <typename Element>
bool ThreadSafeQueue<Element>::Pop(Element& element)
{
	bool popped;
	mMutex.lock();
	{
		if (mQueue.size() > 0)
		{
			element = mQueue.front();
			mQueue.pop();
			popped = true;
		}
		else
		{
			popped = false;
		}
	}
	mMutex.unlock();
	return popped;
}