/**
File:		Core/NeUtil.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#pragma once

#include <NeCoreLib.h>
#include <string>

namespace NeuralEngine
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// <summary>	A Utility class. </summary>
	///
	/// <remarks>	Hmetal T, 11/09/2018. </remarks>
	////////////////////////////////////////////////////////////////////////////////////////////////////
	class NE_IMPEXP Util
	{
	public:

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Converts this object to a wide string. </summary>
		///
		/// <remarks>	Hmetal T, 11/09/2018. </remarks>
		///
		/// <param name="source">	Source for the. </param>
		/// <param name="dest">  	[in,out] Destination for the. </param>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		static void ToWideString(const std::string& source, std::wstring& dest);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Converts a source to a wide string. </summary>
		///
		/// <remarks>	Hmetal T, 11/09/2018. </remarks>
		///
		/// <param name="source">	Source for the. </param>
		///
		/// <returns>	source as a std::wstring. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		static std::wstring ToWideString(const std::string& source);

		////////////////////////////////////////////////////////////////////////////////////////////////////
		/// <summary>	Convert this object into a string representation. </summary>
		///
		/// <remarks>	Hmetal T, 11/09/2018. </remarks>
		///
		/// <param name="source">	Source for the. </param>
		///
		/// <returns>	A std::string that represents this object. </returns>
		////////////////////////////////////////////////////////////////////////////////////////////////////
		static std::string ToString(const std::wstring& source);
	};
}