/**
File:		NECore/InputOutput/NeEFStream.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeEFStream.h>

namespace NeuralEngine
{
	EFStream::EFStream()
		: byte_swap_(false)
	{
	}

	bool EFStream::ByteSwap(void)
	{
		{ return byte_swap_; }
	}

	void EFStream::SetByteSwap(bool state)
	{
		{ byte_swap_ = state; }
	}

	void EFStream::SwapEndian(char * s, std::streamsize N)
	{
		for (unsigned int n = 0; n < N; n += 2) std::swap(s[n], s[n + 1]);
	}

	std::istream & EFStream::Read(char * s, std::streamsize n)
	{
		// call the parent read
		std::istream& stream = std::fstream::read(s, n);
		// swap the endianness if necessary
		if (byte_swap_ && n % 2 == 0) SwapEndian(s, n);
		return stream;
	}
}