/**
File:		NECore/InputOutput/NeLogReporter.h

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeLogReporter.h>

namespace NeuralEngine
{
	LogReporter::~LogReporter()
	{
		if (mLogToStdout)
		{
			Logger::Unsubscribe(mLogToStdout.get());
		}

		if (mLogToFile)
		{
			Logger::Unsubscribe(mLogToFile.get());
		}

#if defined(__MSWINDOWS__)
		if (mLogToOutputWindow)
		{
			Logger::Unsubscribe(mLogToOutputWindow.get());
		}

		if (mLogToMessageBox)
		{
			Logger::Unsubscribe(mLogToMessageBox.get());
		}
#endif
	}

	LogReporter::LogReporter(std::string const& logFile, int logFileFlags,
		int logStdoutFlags, int logMessageBoxFlags, int logOutputWindowFlags)
		:
		mLogToFile(nullptr),
		mLogToStdout(nullptr)
#if defined(__MSWINDOWS__)
		,
		mLogToMessageBox(nullptr),
		mLogToOutputWindow(nullptr)
#endif
	{
		if (logFileFlags != Listener::LISTEN_FOR_NOTHING)
		{
			mLogToFile = std::make_unique<LogToFile>(logFile, logFileFlags);
			Logger::Subscribe(mLogToFile.get());
		}

		if (logStdoutFlags != Listener::LISTEN_FOR_NOTHING)
		{
			mLogToStdout = std::make_unique<LogToStdout>(logStdoutFlags);
			Logger::Subscribe(mLogToStdout.get());
		}

#if defined(__MSWINDOWS__)
		if (logMessageBoxFlags != Listener::LISTEN_FOR_NOTHING)
		{
			mLogToMessageBox = std::make_unique<LogToMessageBox>(logMessageBoxFlags);
			Logger::Subscribe(mLogToMessageBox.get());
		}

		if (logOutputWindowFlags != Listener::LISTEN_FOR_NOTHING)
		{
			mLogToOutputWindow = std::make_unique<LogToOutputWindow>(logOutputWindowFlags);
			Logger::Subscribe(mLogToOutputWindow.get());
		}
#endif
	}
}
