/**
File:		NECore/InputOutput/NeLogToFile.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeLogToFile.h>
#include <fstream>

namespace NeuralEngine
{
	LogToFile::LogToFile(std::string const& filename, int flags)
		:
		Listener(flags),
		mFilename(filename)
	{
		std::ofstream logFile(filename);
		if (logFile)
		{
			// This clears the file contents from any previous runs.
			logFile.close();
		}
		else
		{
			// The file cannot be opened.  Use a null string for Report to know
			// not to attempt opening the file for append.
			mFilename = "";
		}
	}

	void LogToFile::Report(std::string const& message)
	{
		if (mFilename != "")
		{
			// Open for append.
			std::ofstream logFile(mFilename,
				std::ios_base::out | std::ios_base::app);
			if (logFile)
			{
				logFile << message.c_str();
				logFile.close();
			}
			else
			{
				// The file cannot be opened.  Use a null string for Report not
				// to attempt opening the file for append on the next call.
				mFilename = "";
			}
		}
	}
}
