/**
File:		NECore/InputOutput/NeLogToMessageBox.cpp

Author:		
Email:		
Site:       

Copyright (c) 2016 . All rights reserved.
*/

#include <NeCorePCH.h>
#include <Core/NeLogToMessageBox.h>
#include <windows.h>

namespace NeuralEngine
{
	LogToMessageBox::LogToMessageBox(int flags)
		: Listener(flags)
	{
	}

	void LogToMessageBox::Report(const std::string& message)
	{
		std::string output = message + "Do you want to debug?";

		int selection = MessageBox(nullptr, output.c_str(), "Report", MB_ICONERROR | MB_YESNOCANCEL | MB_APPLMODAL | MB_TOPMOST);

		switch (selection)
		{
		case IDYES:
			// Break and debug.
			__debugbreak();
			break;

		case IDNO:
			// Continue execution.
			break;

		case IDCANCEL:
		default:
			// Terminate execution.
			exit(0);
			break;
		}
	}
}